/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.uiscreens;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.Position;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.gpssurvey.ui.ScreenDataChangeProcessor;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.HybridArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelPosition;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Screen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.TextZone;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Zone;

public class PositionScreen
extends Screen
implements ScreenDataChangeProcessor {
    private static final int HALFWIDTH = 80;
    private static final HybridArea fullwidthx1 = new HybridArea(160, 1);
    private static final HybridArea halfwidthx1 = new HybridArea(80, 1);
    private final TextZone header;
    private static final PixelPosition headerpos = new PixelPosition(0, 2);
    private final TextZone refheader;
    private static final PixelPosition refheaderpos = new PixelPosition(0, 30);
    private final TextZone refcourse;
    private static final PixelPosition refcoursepos = new PixelPosition(0, 52);
    private final TextZone refdistance;
    private static final PixelPosition refdistancepos = new PixelPosition(80, 52);
    private final TextZone ptheader;
    private static final PixelPosition ptheaderpos = new PixelPosition(0, 74);
    private final TextZone ptcourse;
    private static final PixelPosition ptcoursepos = new PixelPosition(0, 96);
    private final TextZone ptdistance;
    private static final PixelPosition ptdistancepos = new PixelPosition(80, 96);

    public PositionScreen(SerialTFTDisplay display) throws IOException {
        super("position", display);
        this.header = new TextZone(display, headerpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setCentre().setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.header);
        this.header.insert("Current Location");
        this.refheader = new TextZone(display, refheaderpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.refheader);
        this.refheader.insert("From Reference Location");
        this.refcourse = new TextZone(display, refcoursepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.refcourse);
        this.refdistance = new TextZone(display, refdistancepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.refdistance);
        this.ptheader = new TextZone(display, ptheaderpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.ptheader);
        this.ptheader.insert("From Last Recorded Pt.");
        this.ptcourse = new TextZone(display, ptcoursepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.ptcourse);
        this.ptdistance = new TextZone(display, ptdistancepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.ptdistance);
    }

    protected void hasGainedFocus() throws IOException {
        this.dataChanged(Controller.getLocationData());
    }

    @Override
    public void dataChanged(LocationData ld) throws IOException {
        Position l = ld.getPosition();
        this.refcourse.insert(l.course.toStringWithUnits());
        this.refdistance.insert(l.distance.toStringWithUnits());
        if (ld.hasNoPoints()) {
            this.ptcourse.insert("");
            this.ptdistance.insert("");
        } else {
            Position frompoint = ld.getCurrentFromLastPoint();
            this.ptcourse.insert(frompoint.course.toStringWithUnits());
            this.ptdistance.insert(frompoint.distance.toStringWithUnits());
        }
        this.paint();
    }
}

