/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.uiscreens;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.Position;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.gpssurvey.ui.ScreenDataChangeProcessor;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.HybridArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelPosition;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Screen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.TextZone;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Zone;

public class RecorderStatusScreen
extends Screen
implements ScreenDataChangeProcessor {
    private static final int HALFWIDTH = 80;
    private static final HybridArea fullwidthx1 = new HybridArea(160, 1);
    private static final HybridArea halfwidthx1 = new HybridArea(80, 1);
    private final TextZone header;
    private static final PixelPosition headerpos = new PixelPosition(0, 2);
    private final TextZone pointcount;
    private static final PixelPosition pointcountpos = new PixelPosition(0, 20);
    private final TextZone recordedccount;
    private static final PixelPosition recordedccountpos = new PixelPosition(0, 38);
    private final TextZone reference;
    private static final PixelPosition referencepos = new PixelPosition(0, 58);
    private final TextZone referencecourse;
    private static final PixelPosition referencecoursepos = new PixelPosition(0, 76);
    private final TextZone referencedistance;
    private static final PixelPosition referencedistancepos = new PixelPosition(80, 76);
    private final TextZone recording;
    private static final PixelPosition recordingpos = new PixelPosition(0, 96);
    private final TextZone recordingcourse;
    private static final PixelPosition recordingcoursepos = new PixelPosition(0, 114);
    private final TextZone recordingdistance;
    private static final PixelPosition recordingdistancepos = new PixelPosition(80, 114);

    public RecorderStatusScreen(SerialTFTDisplay display) throws IOException {
        super("recorderstatus", display);
        this.header = new TextZone(display, headerpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setCentre().setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.header);
        this.header.insert("Recorder Status");
        this.pointcount = new TextZone(display, pointcountpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1);
        this.addZone((Zone)this.pointcount);
        this.recordedccount = new TextZone(display, recordedccountpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1);
        this.addZone((Zone)this.recordedccount);
        this.reference = new TextZone(display, referencepos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1);
        this.addZone((Zone)this.reference);
        this.referencecourse = new TextZone(display, referencecoursepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.referencecourse);
        this.referencedistance = new TextZone(display, referencedistancepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.referencedistance);
        this.recording = new TextZone(display, recordingpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1);
        this.addZone((Zone)this.recording);
        this.recordingcourse = new TextZone(display, recordingcoursepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.recordingcourse);
        this.recordingdistance = new TextZone(display, recordingdistancepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.recordingdistance);
    }

    protected void hasGainedFocus() throws IOException {
        this.dataChanged(Controller.getLocationData());
    }

    @Override
    public void dataChanged(LocationData ld) throws IOException {
        this.pointcount.insert(String.format("Recorded %3d points", ld.getPointsSize()));
        this.recordedccount.insert(String.format("Recorded %3d tracks", ld.getStartEndPointsSize()));
        double refcourse = 0.0;
        if (ld.hasNoStartEndPoints()) {
            this.reference.insert("No Reference Track");
            this.referencecourse.insert("");
            this.referencedistance.insert("");
        } else {
            this.reference.insert("Reference Track");
            Position ref = ld.getFirstStartEnd();
            refcourse = ref.course.get();
            double inverse = refcourse >= 180.0 ? refcourse - 180.0 : refcourse + 180.0;
            this.referencecourse.insert(String.format("%3.0f\u00b0 (%3.0f\u00b0)", refcourse, inverse));
            this.referencedistance.insert(ref.distance.toStringWithUnits());
        }
        if (ld.isRecording()) {
            this.recording.insert("Recording ...");
            Position current = ld.getPosition();
            this.recordingcourse.insert(current.course.toStringWithUnits());
            this.recordingdistance.insert(current.distance.toStringWithUnits());
        } else if (ld.hasNoStartEndPoints()) {
            this.recording.insert("Not Recording");
            this.recordingcourse.insert("");
            this.recordingdistance.insert("");
        } else {
            Position offsetfromend = ld.getCurrentFromEnd();
            double offset = Math.abs(offsetfromend.distance.get() * Math.sin(Math.toRadians(offsetfromend.course.get() - refcourse)));
            this.recording.insert("Not Recording");
            this.recordingcourse.insert("Offset: ");
            this.recordingdistance.insert(String.format("%8.1f m", offset));
        }
        this.paint();
    }
}

