/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.uiscreens;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.HybridArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelPosition;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Screen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.TextZone;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Zone;

public class ReferenceLocationScreen
extends Screen {
    private static final int LABELWIDTH = 70;
    private static final HybridArea fullwidthx1 = new HybridArea(160, 1);
    private static final HybridArea labelwidthx1 = new HybridArea(70, 1);
    private static final HybridArea fieldwidthx1 = new HybridArea(90, 1);
    private final TextZone header;
    private static final PixelPosition headerpos = new PixelPosition(0, 0);
    private final TextZone northlabel;
    private static final PixelPosition northlabelpos = new PixelPosition(0, 24);
    private final TextZone north;
    private static final PixelPosition northpos = new PixelPosition(70, 24);
    private final TextZone eastlabel;
    private static final PixelPosition eastlabelpos = new PixelPosition(0, 42);
    private final TextZone east;
    private static final PixelPosition eastpos = new PixelPosition(70, 42);
    private final TextZone depthlabel;
    private static final PixelPosition depthlabelpos = new PixelPosition(0, 60);
    private final TextZone depth;
    private static final PixelPosition depthpos = new PixelPosition(70, 60);
    private final boolean displaydepth;

    public ReferenceLocationScreen(SerialTFTDisplay display, boolean displaydepth) throws IOException {
        super("reference location", display);
        this.displaydepth = displaydepth;
        this.header = new TextZone(display, headerpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setForeground(SerialTFTDisplay.Colour.GREEN).setCentre();
        this.addZone((Zone)this.header);
        this.header.insert("Reference Location");
        this.northlabel = new TextZone(display, northlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.northlabel);
        this.northlabel.insert("North: ");
        this.north = new TextZone(display, northpos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.north);
        this.eastlabel = new TextZone(display, eastlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.eastlabel);
        this.eastlabel.insert("East: ");
        this.east = new TextZone(display, eastpos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.east);
        this.depthlabel = new TextZone(display, depthlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.depthlabel);
        this.depthlabel.insert(displaydepth ? "Depth: " : "Altitude: ");
        this.depth = new TextZone(display, depthpos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.depth);
    }

    protected void hasGainedFocus() throws IOException {
        LocationData ld = Controller.getLocationData();
        LocationData.Location l = ld.getReferenceLocation();
        if (l == null) {
            throw new IOException("Reference Location Screen gained focus, but reference location not available from InformationStore");
        }
        this.north.insert(l.getPosition().latitude.toStringWithUnits());
        this.east.insert(l.getPosition().longitude.toStringWithUnits());
        this.depth.insert(this.displaydepth ? l.getDepth().toStringWithUnits() : l.getAltitude().toStringWithUnits());
    }
}

