/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.uiscreens;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.input.IRControlAction;
import uk.theretiredprogrammer.gpssurvey.ui.Action;
import uk.theretiredprogrammer.gpssurvey.ui.ButtonActions;
import uk.theretiredprogrammer.gpssurvey.ui.SelectUsingButtonScreen;
import uk.theretiredprogrammer.gpssurvey.ui.View;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;

public class SelectPowerDownOptionScreen
extends SelectUsingButtonScreen {
    public SelectPowerDownOptionScreen(SerialTFTDisplay display) throws IOException {
        super("SelectPowerDownOption", display, new ButtonActions("SYSTEM EXIT REQUEST", "Cancel", new CancelAction()).addLine(IRControlAction.Button.A, "Power Off", new PowerOffAction()).addLine(IRControlAction.Button.B, "Reboot", new RebootAction()).addLine(IRControlAction.Button.C, "Restart GPS", new RestartAction()));
    }

    public static class RestartAction
    implements Action {
        @Override
        public void execute() throws IOException {
            View.displayNextScreenAndExit(MDTService.Exitcode.EXIT_OK, "Restarting...");
        }
    }

    public static class RebootAction
    implements Action {
        @Override
        public void execute() throws IOException {
            View.displayNextScreenAndExit(MDTService.Exitcode.EXIT_REBOOT, "Rebooting...");
        }
    }

    public static class PowerOffAction
    implements Action {
        @Override
        public void execute() throws IOException {
            View.displayNextScreenAndExit(MDTService.Exitcode.EXIT_POWEROFF, "Powering down...");
        }
    }

    public static class CancelAction
    implements Action {
        @Override
        public void execute() throws IOException {
            View.displayPreviousScreenSet();
        }
    }
}

