/*
 * Decompiled with CFR 0.152.
 */
package uk.wardm.formaker.generator.pojo;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import uk.wardm.formaker.annotation.Exclude;
import uk.wardm.formaker.annotation.Password;
import uk.wardm.formaker.annotation.Range;
import uk.wardm.formaker.annotation.Select;
import uk.wardm.formaker.annotation.TextBox;
import uk.wardm.formaker.generator.pojo.ComponentFactory;
import uk.wardm.formaker.generator.pojo.DefaultFieldTypeConverter;
import uk.wardm.formaker.model.ChoiceField;
import uk.wardm.formaker.model.Component;
import uk.wardm.formaker.model.InputField;
import uk.wardm.formaker.model.NumberField;
import uk.wardm.formaker.model.PasswordField;
import uk.wardm.formaker.model.TextBoxField;

public class ComponentFactoryImpl
implements ComponentFactory {
    @Override
    public Optional<Component> createFromField(Field field) {
        Class<?> formClass = field.getDeclaringClass();
        String label = String.join((CharSequence)".", formClass.getName(), field.getName());
        Class<? extends InputField> formType = DefaultFieldTypeConverter.formTypeFor(field.getType());
        if (field.isAnnotationPresent(Exclude.class)) {
            return Optional.empty();
        }
        if (field.isAnnotationPresent(Password.class)) {
            return Optional.of(new PasswordField(field.getName(), label));
        }
        if (field.isAnnotationPresent(TextBox.class)) {
            return Optional.of(new TextBoxField(field.getName(), label));
        }
        if (field.isAnnotationPresent(Select.class)) {
            Select select = field.getAnnotation(Select.class);
            List<ChoiceField.Option> options = Arrays.stream(select.value()).map(value -> new ChoiceField.Option((String)value, value)).collect(Collectors.toList());
            return Optional.of(new ChoiceField(field.getName(), label, options));
        }
        if (formType.equals(ChoiceField.class)) {
            List<ChoiceField.Option> options = new ArrayList<ChoiceField.Option>();
            if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
                options.add(new ChoiceField.Option("true", "true"));
                options.add(new ChoiceField.Option("false", "false"));
            } else if (field.getType().isEnum()) {
                options = Arrays.stream(field.getType().getEnumConstants()).map(value -> new ChoiceField.Option(value.toString(), value)).collect(Collectors.toList());
            }
            return Optional.of(new ChoiceField(field.getName(), label, options));
        }
        if (formType.equals(NumberField.class)) {
            Long min = null;
            if (field.isAnnotationPresent(Min.class)) {
                min = field.getAnnotation(Min.class).value();
            }
            Long max = null;
            if (field.isAnnotationPresent(Max.class)) {
                max = field.getAnnotation(Max.class).value();
            }
            NumberField numberField = new NumberField(field.getName(), label, min, max);
            if (field.isAnnotationPresent(Range.class) && min != null && max != null) {
                numberField.setUseSlider(true);
            }
            return Optional.of(numberField);
        }
        try {
            Constructor<? extends InputField> ctor = formType.getConstructor(String.class, String.class);
            return Optional.of((Component)ctor.newInstance(field.getName(), label));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No valid constructor for " + formType.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create " + formType.getName());
        }
    }
}

