/*
 * Decompiled with CFR 0.152.
 */
package uk.wardm.formaker.generator.pojo;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uk.wardm.formaker.model.ChoiceField;
import uk.wardm.formaker.model.DateField;
import uk.wardm.formaker.model.InputField;
import uk.wardm.formaker.model.NumberField;
import uk.wardm.formaker.model.TextField;

public abstract class DefaultFieldTypeConverter {
    private static final Map<Class<?>, Class<? extends InputField>> map = new HashMap();

    public static Set<Class<?>> supportedTypes() {
        return map.keySet();
    }

    public static Class<? extends InputField> formTypeFor(Class<?> javaType) {
        if (map.containsKey(javaType = DefaultFieldTypeConverter.normaliseType(javaType))) {
            return map.get(javaType);
        }
        throw new IllegalArgumentException("Unsupported type: " + javaType.getName());
    }

    private static Class<?> normaliseType(Class<?> javaType) {
        if (javaType.isEnum()) {
            return Enum.class;
        }
        return javaType;
    }

    public static boolean supports(Class<?> type) {
        type = DefaultFieldTypeConverter.normaliseType(type);
        return DefaultFieldTypeConverter.supportedTypes().contains(type);
    }

    static {
        map.put(String.class, TextField.class);
        map.put(LocalDate.class, DateField.class);
        map.put(Integer.TYPE, NumberField.class);
        map.put(Integer.class, NumberField.class);
        map.put(Byte.TYPE, NumberField.class);
        map.put(Byte.class, NumberField.class);
        map.put(Short.TYPE, NumberField.class);
        map.put(Short.class, NumberField.class);
        map.put(Long.TYPE, NumberField.class);
        map.put(Long.class, NumberField.class);
        map.put(Boolean.class, ChoiceField.class);
        map.put(Boolean.TYPE, ChoiceField.class);
        map.put(Enum.class, ChoiceField.class);
    }
}

