/*
 * Decompiled with CFR 0.152.
 */
package uk.wardm.formaker.generator.pojo;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.wardm.formaker.generator.pojo.ComponentFactory;
import uk.wardm.formaker.generator.pojo.ComponentFactoryImpl;
import uk.wardm.formaker.generator.pojo.DefaultFieldTypeConverter;
import uk.wardm.formaker.model.Form;
import uk.wardm.formaker.model.InputField;

public class FormModelImpl
implements Form {
    private final Map<String, InputField> fields = new LinkedHashMap<String, InputField>();
    private final ComponentFactory componentFactory = new ComponentFactoryImpl();

    public FormModelImpl(Object target) {
        this.initFields(target.getClass());
    }

    @Override
    public Collection<InputField> getFields() {
        return this.fields.values();
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public InputField getField(String name) {
        if (this.fields.containsKey(name)) {
            return this.fields.get(name);
        }
        throw new IllegalArgumentException("No field with name " + name + " exists");
    }

    private void initFields(Class formClass) {
        for (Field field : formClass.getDeclaredFields()) {
            if (!DefaultFieldTypeConverter.supports(field.getType())) continue;
            this.componentFactory.createFromField(field).ifPresent(component -> {
                InputField inputField = (InputField)component;
                this.fields.put(inputField.getName(), inputField);
            });
        }
    }
}

