/*
 * Decompiled with CFR 0.152.
 */
package uk.wardm.formaker.transformer.thymeleaf;

import java.util.Arrays;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.ITemplateEvent;
import uk.wardm.formaker.model.ChoiceField;
import uk.wardm.formaker.model.Component;
import uk.wardm.formaker.model.DateField;
import uk.wardm.formaker.model.InputField;
import uk.wardm.formaker.model.NumberField;
import uk.wardm.formaker.model.PasswordField;
import uk.wardm.formaker.model.TextBoxField;
import uk.wardm.formaker.transformer.thymeleaf.ComponentRenderer;

public abstract class AbstractComponentRenderer
implements ComponentRenderer {
    private final boolean renderRendererWarnings;

    public AbstractComponentRenderer(boolean renderRendererWarnings) {
        this.renderRendererWarnings = renderRendererWarnings;
    }

    public AbstractComponentRenderer() {
        this(true);
    }

    @Override
    public IModel render(ITemplateContext context, Component component) {
        IModelFactory modelFactory = context.getModelFactory();
        if (component instanceof InputField) {
            IModel model = modelFactory.createModel();
            InputField inputField = (InputField)component;
            this.beforeComponent(modelFactory, model);
            this.renderFieldLabel(context, modelFactory, model, inputField);
            this.renderInputControl(context, modelFactory, model, inputField);
            this.renderFieldErrors(modelFactory, model, inputField);
            this.afterComponent(modelFactory, model);
            return model;
        }
        IModel model = modelFactory.createModel();
        if (this.renderRendererWarnings) {
            model.add((ITemplateEvent)modelFactory.createOpenElementTag("p"));
            model.add((ITemplateEvent)modelFactory.createText((CharSequence)("Unable to render field for " + component.getClass())));
            model.add((ITemplateEvent)modelFactory.createCloseElementTag("p"));
        }
        return model;
    }

    protected abstract void beforeComponent(IModelFactory var1, IModel var2);

    protected abstract void afterComponent(IModelFactory var1, IModel var2);

    protected abstract void renderFieldLabel(ITemplateContext var1, IModelFactory var2, IModel var3, InputField var4);

    protected void renderInputControl(ITemplateContext context, IModelFactory modelFactory, IModel model, InputField inputField) {
        String fqPlaceholderKey = inputField.getLabel() + ".placeholder";
        String placeholderText = this.resolveMessage(context, fqPlaceholderKey, "");
        if (inputField instanceof TextBoxField) {
            this.renderTextBox((TextBoxField)inputField, placeholderText, modelFactory, model);
        } else if (inputField instanceof ChoiceField) {
            this.renderChoiceField((ChoiceField)inputField, modelFactory, model, context);
        } else {
            this.renderTextField(inputField, placeholderText, modelFactory, model);
        }
    }

    protected abstract void renderTextBox(TextBoxField var1, String var2, IModelFactory var3, IModel var4);

    protected abstract void renderTextField(InputField var1, String var2, IModelFactory var3, IModel var4);

    protected abstract void renderChoiceField(ChoiceField var1, IModelFactory var2, IModel var3, ITemplateContext var4);

    protected abstract void renderFieldErrors(IModelFactory var1, IModel var2, InputField var3);

    protected String resolveMessage(ITemplateContext context, String fqKey, String defaultValue) {
        Object[] emptyParams = new Object[]{};
        String prefix = "fm.";
        String[] keyParts = fqKey.split("\\.");
        String value = context.getMessage(this.getClass(), fqKey, emptyParams, false);
        if (value != null) {
            return value;
        }
        for (int i = keyParts.length - 1; i > 0; --i) {
            String key = String.join((CharSequence)".", Arrays.copyOfRange(keyParts, i, keyParts.length));
            value = context.getMessage(this.getClass(), key, emptyParams, false);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    protected String htmlInputType(InputField inputField) {
        if (inputField instanceof PasswordField) {
            return "password";
        }
        if (inputField instanceof NumberField) {
            NumberField numberField = (NumberField)inputField;
            if (numberField.isUseSlider() && numberField.getMin() != null && numberField.getMax() != null) {
                return "range";
            }
            return "number";
        }
        if (inputField instanceof DateField) {
            return "date";
        }
        return "text";
    }
}

