/*
 * Decompiled with CFR 0.152.
 */
package uk.wardm.formaker.transformer.thymeleaf;

import java.util.Map;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.ITemplateEvent;
import org.unbescape.html.HtmlEscape;
import uk.wardm.formaker.model.ChoiceField;
import uk.wardm.formaker.model.InputField;
import uk.wardm.formaker.model.NumberField;
import uk.wardm.formaker.model.TextBoxField;
import uk.wardm.formaker.transformer.thymeleaf.AbstractComponentRenderer;
import uk.wardm.formaker.transformer.thymeleaf.BootstrapConfig;

public class BootstrapComponentRenderer
extends AbstractComponentRenderer {
    private BootstrapConfig config;

    public BootstrapComponentRenderer() {
        this.config = new BootstrapConfig();
    }

    public BootstrapComponentRenderer(boolean renderRendererWarnings, BootstrapConfig config) {
        super(renderRendererWarnings);
        this.config = config;
    }

    @Override
    protected void beforeComponent(IModelFactory modelFactory, IModel model) {
        Map<String, String> attrs = this.config.getFormGroupAttrs();
        model.add((ITemplateEvent)modelFactory.createOpenElementTag("div", attrs, AttributeValueQuotes.DOUBLE, false));
    }

    @Override
    protected void afterComponent(IModelFactory modelFactory, IModel model) {
        model.add((ITemplateEvent)modelFactory.createCloseElementTag("div"));
    }

    @Override
    protected void renderFieldLabel(ITemplateContext context, IModelFactory modelFactory, IModel model, InputField inputField) {
        String id = inputField.getName();
        model.add((ITemplateEvent)modelFactory.createOpenElementTag("label", "for", HtmlEscape.escapeHtml5((String)id)));
        String labelText = this.resolveMessage(context, inputField.getLabel(), inputField.getName());
        model.add((ITemplateEvent)modelFactory.createText((CharSequence)HtmlEscape.escapeHtml5((String)labelText)));
        model.add((ITemplateEvent)modelFactory.createCloseElementTag("label"));
    }

    @Override
    protected void renderFieldErrors(IModelFactory modelFactory, IModel model, InputField inputField) {
        Map<String, String> errorAttrs = this.config.getFieldErrorsAttrs();
        errorAttrs.put("th:errors", "*{" + inputField.getName() + "}");
        model.add((ITemplateEvent)modelFactory.createOpenElementTag("div", errorAttrs, AttributeValueQuotes.DOUBLE, false));
        model.add((ITemplateEvent)modelFactory.createCloseElementTag("div"));
    }

    @Override
    protected void renderTextBox(TextBoxField inputField, String placeholderText, IModelFactory modelFactory, IModel model) {
        Map<String, String> attrs = this.config.getTextBoxAttrs();
        attrs.put("placeholder", HtmlEscape.escapeHtml5((String)placeholderText));
        attrs.put("th:field", "*{" + inputField.getName() + "}");
        model.add((ITemplateEvent)modelFactory.createOpenElementTag("textarea", attrs, AttributeValueQuotes.DOUBLE, false));
        model.add((ITemplateEvent)modelFactory.createCloseElementTag("textarea"));
    }

    @Override
    protected void renderTextField(InputField inputField, String placeholderText, IModelFactory modelFactory, IModel model) {
        String typeAttr = this.htmlInputType(inputField);
        Map<String, String> attrs = typeAttr.equals("range") ? this.config.getRangeControlAttrs() : this.config.getTextInputAttrs();
        attrs.put("type", typeAttr);
        attrs.put("id", inputField.getName());
        if (inputField instanceof NumberField) {
            NumberField numberField = (NumberField)inputField;
            attrs.put("min", numberField.getMin() != null ? numberField.getMin().toString() : null);
            attrs.put("max", numberField.getMax() != null ? numberField.getMax().toString() : null);
        }
        attrs.put("placeholder", HtmlEscape.escapeHtml5((String)placeholderText));
        attrs.put("th:field", "*{" + inputField.getName() + "}");
        model.add((ITemplateEvent)modelFactory.createStandaloneElementTag("input", attrs, AttributeValueQuotes.DOUBLE, false, false));
    }

    @Override
    protected void renderChoiceField(ChoiceField choiceField, IModelFactory modelFactory, IModel model, ITemplateContext context) {
        Map<String, String> attrs = this.config.getSelectAttrs();
        attrs.put("th:field", "*{" + choiceField.getName() + "}");
        model.add((ITemplateEvent)modelFactory.createOpenElementTag("select", attrs, AttributeValueQuotes.DOUBLE, false));
        for (ChoiceField.Option option : choiceField.getOptions()) {
            String fqOptionLabelKey = choiceField.getLabel() + ".labels." + option.getLabelKey();
            String optionValueAsText = String.valueOf(option.getValue());
            String optionText = this.resolveMessage(context, fqOptionLabelKey, optionValueAsText);
            model.add((ITemplateEvent)modelFactory.createOpenElementTag("option", "value", optionValueAsText));
            model.add((ITemplateEvent)modelFactory.createText((CharSequence)optionText));
            model.add((ITemplateEvent)modelFactory.createCloseElementTag("option"));
        }
        model.add((ITemplateEvent)modelFactory.createCloseElementTag("select"));
    }
}

