/*
 * Decompiled with CFR 0.152.
 */
package uk.wardm.formaker.transformer.thymeleaf;

import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.processor.element.AbstractAttributeModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import uk.wardm.formaker.generator.pojo.FormModelImpl;
import uk.wardm.formaker.model.Component;
import uk.wardm.formaker.transformer.thymeleaf.ComponentRenderer;

public class FormFieldsTagProcessor
extends AbstractAttributeModelProcessor {
    private static final String FORM_OBJECT_ATTR_NAME = "form";
    private static final int PRECEDENCE = 10000;
    private ComponentRenderer renderer;

    public FormFieldsTagProcessor(String dialectPrefix, ComponentRenderer renderer) {
        super(TemplateMode.HTML, dialectPrefix, "form-fields", true, FORM_OBJECT_ATTR_NAME, true, 10000, true);
        this.renderer = renderer;
    }

    protected void doProcess(ITemplateContext context, IModel model, AttributeName attributeName, String attributeValue, IElementModelStructureHandler structureHandler) {
        IEngineConfiguration configuration = context.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
        IStandardExpression expression = parser.parseExpression((IExpressionContext)context, attributeValue);
        Object formPojo = expression.execute((IExpressionContext)context);
        FormModelImpl form = new FormModelImpl(formPojo);
        IModelFactory modelFactory = context.getModelFactory();
        IModel fields = modelFactory.createModel();
        for (Component component : form.getFields()) {
            fields.addModel(this.renderer.render(context, component));
        }
        model.remove(0);
        model.addModel(fields);
    }
}

