/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.common.app;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uno.anahata.mapacho.common.app.MapachoArtifact;
import uno.anahata.mapacho.common.runtime.JRE;

public class MapachoApplication
implements Serializable {
    private URL codeBase;
    private String displayName;
    private String displayVer;
    private String splash;
    private String preloaderClass;
    private JRE jre;
    private List<MapachoArtifact> classpath = new ArrayList<MapachoArtifact>();
    private Map<String, String> properties = new HashMap<String, String>();
    private String jvmArgs = "";
    private String mainClass;
    private List<String> arguments = new ArrayList<String>();

    public List<MapachoArtifact> getMatchingArtifacts() {
        return this.classpath.stream().filter(a -> a.matches()).collect(Collectors.toList());
    }

    public List<MapachoArtifact> getMatchingLibPath() {
        return this.getMatchingArtifacts().stream().filter(a -> a.isNativeLib()).collect(Collectors.toList());
    }

    public List<MapachoArtifact> getMatchingClassPath() {
        return this.getMatchingArtifacts().stream().filter(a -> !a.isNativeLib()).collect(Collectors.toList());
    }

    public String toString() {
        String base = "MapachoApplication{codeBase=" + this.codeBase + ",\n\n displayName=" + this.displayName + ",\n displayVer=" + this.displayVer + ",\n splash=" + this.splash + ",\n preloaderClass=" + this.preloaderClass + ",\n jre=" + this.jre + ",\n properties=" + this.properties + ",\n jvmArgs=" + this.jvmArgs + ",\n mainClass=" + this.mainClass + ",\n arguments=" + this.arguments + ",\n classpath=" + this.classpath.size();
        for (MapachoArtifact mapachoArtifact : this.classpath) {
            base = base + ",\n     " + mapachoArtifact.getJarFileName();
        }
        base = base + "}";
        return base;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayVer() {
        return this.displayVer;
    }

    public String getSplash() {
        return this.splash;
    }

    public String getPreloaderClass() {
        return this.preloaderClass;
    }

    public JRE getJre() {
        return this.jre;
    }

    public List<MapachoArtifact> getClasspath() {
        return this.classpath;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setCodeBase(URL codeBase) {
        this.codeBase = codeBase;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDisplayVer(String displayVer) {
        this.displayVer = displayVer;
    }

    public void setSplash(String splash) {
        this.splash = splash;
    }

    public void setPreloaderClass(String preloaderClass) {
        this.preloaderClass = preloaderClass;
    }

    public void setJre(JRE jre) {
        this.jre = jre;
    }

    public void setClasspath(List<MapachoArtifact> classpath) {
        this.classpath = classpath;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }
}

