/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.common.app;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import uno.anahata.mapacho.common.app.MapachoApplication;
import uno.anahata.mapacho.common.runtime.JRE;

public class MapachoArtifact
implements Serializable {
    public static final String CLASSIFIER_TOKEN = "__";
    public static final String OS_TOKEN = "O";
    public static final String ARCH_TOKEN = "A";
    public static final String LOCALTE_TOKEN = "L";
    public static final String VERSION_TOKEN = "V";
    private MapachoApplication application;
    private String name = "";
    private String os = "";
    private String arch = "";
    private String locale = "";
    private String version = "";
    private boolean nativeLib = false;
    private transient File file;

    public final String getBaseFileName() {
        String ret = this.name;
        ret = ret + MapachoArtifact.addClassifier(OS_TOKEN, this.os);
        ret = ret + MapachoArtifact.addClassifier(ARCH_TOKEN, this.arch);
        ret = ret + MapachoArtifact.addClassifier(LOCALTE_TOKEN, this.locale);
        ret = ret + MapachoArtifact.addClassifier(VERSION_TOKEN, this.version);
        return ret;
    }

    private static String addClassifier(String classifier, String value) {
        String ret = "";
        if (!StringUtils.isBlank((CharSequence)value)) {
            ret = ret + CLASSIFIER_TOKEN + classifier + value;
        }
        return ret;
    }

    public final String getJarFileName() {
        return this.getBaseFileName() + ".jar";
    }

    public final String getJarPackGzFileName() {
        return this.getJarFileName() + ".pack.gz";
    }

    public String getJnlpDependencyString(String libDir, boolean main, String download) {
        String ret = "<jar href=\"" + libDir + "/" + this.name + ".jar\" version=\"" + this.version + "\"";
        if (!StringUtils.isBlank((CharSequence)download)) {
            ret = ret + " download=\"" + download + "\"";
        }
        if (main) {
            ret = ret + " main=\"true\"";
        }
        ret = ret + "/>";
        return ret;
    }

    public File getLibDir(File repo) throws Exception {
        return new File(repo, this.getBaseFileName());
    }

    public File getFile(File repo) throws Exception {
        return new File(repo, this.getJarFileName());
    }

    public static MapachoArtifact fromFile(MapachoApplication application, File f) {
        MapachoArtifact ret = new MapachoArtifact();
        ret.setApplication(application);
        ret.setFile(f);
        String[] chunks = f.getName().split(CLASSIFIER_TOKEN);
        String base = chunks[0];
        ret.setName(base);
        for (int i = 1; i < chunks.length; ++i) {
            String chunk = chunks[i];
            String classifier = chunk.substring(0, 1);
            String value = chunk.substring(1);
            if (value.contains(".")) {
                value = value.substring(0, value.indexOf("."));
            }
            if (classifier.equals(OS_TOKEN)) {
                ret.setOs(value);
                continue;
            }
            if (classifier.equals(ARCH_TOKEN)) {
                ret.setArch(value);
                continue;
            }
            if (classifier.equals(LOCALTE_TOKEN)) {
                ret.setLocale(value);
                continue;
            }
            if (classifier.equals(VERSION_TOKEN)) {
                ret.setVersion(value);
                continue;
            }
            throw new IllegalStateException("Could not parse token classifier=" + classifier + "=" + value + " in " + f);
        }
        return ret;
    }

    private static boolean equals(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.trim().toLowerCase().equalsIgnoreCase(s2.trim().toLowerCase());
    }

    private static boolean matches(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.trim().toLowerCase().startsWith(s2.trim().toLowerCase());
    }

    private boolean isSameArtifactButDifferentVersion(MapachoArtifact ma) {
        return MapachoArtifact.equals(this.name, ma.getName()) && MapachoArtifact.equals(this.os, ma.getOs()) && MapachoArtifact.equals(this.arch, ma.getArch()) && MapachoArtifact.equals(this.locale, ma.getLocale());
    }

    public MapachoArtifact getBestCurrentVersionMatch(File repo) throws Exception {
        System.out.println("Looking for closest Match of + " + this + " in " + repo);
        MapachoArtifact lastMod = null;
        for (File f : repo.listFiles()) {
            MapachoArtifact ma = MapachoArtifact.fromFile(this.application, f);
            if (!this.isSameArtifactButDifferentVersion(ma) || lastMod != null && lastMod.getFile().lastModified() >= f.lastModified()) continue;
            lastMod = ma;
        }
        System.out.println("Looking for closest Match of + " + this + " in " + repo + " =" + lastMod);
        return lastMod;
    }

    public boolean matches() {
        JRE jre = this.application.getJre();
        String defaultLocale = Locale.getDefault().toString();
        return MapachoArtifact.matches(jre.getOs(), this.os) && MapachoArtifact.matches(defaultLocale, this.locale) && MapachoArtifact.matches(jre.getArch(), this.arch);
    }

    public String toString() {
        String app = this.application != null ? this.application.getDisplayName() + "v" + this.application.getDisplayVer() : "<not_set>";
        return "MapachoArtifact{application=" + app + ", name=" + this.name + ", version=" + this.version + ", file=" + this.file + '}';
    }

    public MapachoApplication getApplication() {
        return this.application;
    }

    public String getName() {
        return this.name;
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isNativeLib() {
        return this.nativeLib;
    }

    public File getFile() {
        return this.file;
    }

    public void setApplication(MapachoApplication application) {
        this.application = application;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setNativeLib(boolean nativeLib) {
        this.nativeLib = nativeLib;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @ConstructorProperties(value={"application", "name", "os", "arch", "locale", "version", "nativeLib", "file"})
    public MapachoArtifact(MapachoApplication application, String name, String os, String arch, String locale, String version, boolean nativeLib, File file) {
        this.application = application;
        this.name = name;
        this.os = os;
        this.arch = arch;
        this.locale = locale;
        this.version = version;
        this.nativeLib = nativeLib;
        this.file = file;
    }

    public MapachoArtifact() {
    }
}

