/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.common.io;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import uno.anahata.mapacho.common.io.StreamCache;

public class CachingInputStream
extends FilterInputStream {
    private final StreamCache cache;

    public CachingInputStream(InputStream in, File target) throws IOException {
        super(in);
        this.cache = new StreamCache(target);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = super.read(b, off, len);
        this.cache.getStream().write(b, off, len);
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = super.read(b);
        this.cache.getStream().write(b);
        return ret;
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        this.cache.getStream().write(ret);
        return ret;
    }
}

