/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.common.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MapachoIOUtils {
    public static void extractJarFile(File jarFile, File destDir) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> enumEntries = jar.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                File f = new File(destDir + File.separator + file.getName());
                if (file.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                InputStream is = jar.getInputStream(file);
                Throwable throwable = null;
                try {
                    FileOutputStream fos = new FileOutputStream(f);
                    Throwable throwable2 = null;
                    try {
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    public static void putInJar(InputStream is, File jar, String path) throws IOException {
        try (FileSystem zipfs = MapachoIOUtils.getZipFileSystem(jar);){
            Path pathInZipfile = zipfs.getPath(path, new String[0]);
            if (Files.exists(pathInZipfile, new LinkOption[0])) {
                System.out.println("About to delete  " + pathInZipfile);
                Files.delete(pathInZipfile);
            }
            if (is != null) {
                System.out.println("Copying " + is + " to " + pathInZipfile);
                Files.copy(is, pathInZipfile, new CopyOption[0]);
            }
        }
    }

    public static FileSystem getZipFileSystem(File jar) throws IOException {
        HashMap<String, String> zip_properties = new HashMap<String, String>();
        zip_properties.put("create", "false");
        String absolutePath = jar.getAbsolutePath();
        if (!absolutePath.startsWith("/")) {
            absolutePath = "///" + absolutePath.replace("\\", "/");
        }
        URI zip_disk = URI.create("jar:file:" + absolutePath);
        return FileSystems.newFileSystem(zip_disk, zip_properties);
    }
}

