/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.common.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class StreamCache
implements Closeable,
AutoCloseable {
    private final FileOutputStream stream;
    private final File tempFile;
    private final File target;

    public StreamCache(File target) throws IOException {
        this.target = target;
        this.tempFile = File.createTempFile(FilenameUtils.getBaseName((String)target.getName()), FilenameUtils.getExtension((String)target.getName()));
        System.out.println("Caching stream to " + this.tempFile + " will be moved to " + target + " on completion ");
        this.stream = new FileOutputStream(this.tempFile);
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            try {
                System.out.println("Renaming " + this.tempFile + " to " + this.target);
                this.tempFile.renameTo(this.target);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Exception Renaming " + this.tempFile + " to " + this.target);
            }
        }
    }

    public FileOutputStream getStream() {
        return this.stream;
    }
}

