/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.common.jardiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import uno.anahata.mapacho.common.jardiff.JarDiffConstants;
import uno.anahata.mapacho.common.jardiff.JarDiffPatcher;

public class JarDiff
implements JarDiffConstants {
    private static final int DEFAULT_READ_SIZE = 2048;
    private static boolean _debug = false;

    public static void createPatch(File oldPath, File newPath, OutputStream os, boolean minimal) throws IOException {
        long ts = System.currentTimeMillis();
        JarFile2 oldJar = new JarFile2(oldPath.getAbsolutePath());
        JarFile2 newJar = new JarFile2(newPath.getAbsolutePath());
        try {
            String oldName;
            HashMap<String, String> moved = new HashMap<String, String>();
            HashSet visited = new HashSet();
            HashSet<String> implicit = new HashSet<String>();
            HashSet<String> moveSrc = new HashSet<String>();
            HashSet<String> newEntries = new HashSet<String>();
            Iterator<Object> entries = newJar.getJarEntries();
            if (entries != null) {
                while (entries.hasNext()) {
                    JarEntry newEntry = (JarEntry)entries.next();
                    if (_debug) {
                        System.out.println("newEntry " + newEntry + " " + newEntry.getCrc());
                    }
                    String newname = newEntry.getName();
                    String oldname = oldJar.getBestMatch(newJar, newEntry);
                    boolean identical = newname.equalsIgnoreCase(oldname);
                    if (_debug) {
                        System.out.println("Best match for " + newname + " is " + oldname + " identical = " + identical);
                    }
                    if (newEntry.isDirectory()) {
                        if (identical) {
                            implicit.add(newname);
                            continue;
                        }
                        newEntries.add(newname);
                        continue;
                    }
                    if (oldname == null) {
                        if (_debug) {
                            System.out.println("NEW: " + newname);
                        }
                        newEntries.add(newname);
                        continue;
                    }
                    if (oldname.equals(newname) && !moveSrc.contains(oldname)) {
                        if (_debug) {
                            System.out.println(newname + " added to implicit set!");
                        }
                        implicit.add(newname);
                        continue;
                    }
                    if (!minimal && (implicit.contains(oldname) || moveSrc.contains(oldname))) {
                        if (_debug) {
                            System.out.println("NEW: " + newname);
                        }
                        newEntries.add(newname);
                    } else {
                        if (_debug) {
                            System.out.println("moved.put " + newname + " " + oldname);
                        }
                        moved.put(newname, oldname);
                        moveSrc.add(oldname);
                    }
                    if (!implicit.contains(oldname) || !minimal) continue;
                    if (_debug) {
                        System.out.println("implicit.remove " + oldname);
                        System.out.println("moved.put " + oldname + " " + oldname);
                    }
                    implicit.remove(oldname);
                    moved.put(oldname, oldname);
                    moveSrc.add(oldname);
                }
            }
            ArrayList<String> deleted = new ArrayList<String>();
            entries = oldJar.getJarEntries();
            if (entries != null) {
                while (entries.hasNext()) {
                    JarEntry oldEntry = (JarEntry)entries.next();
                    oldName = oldEntry.getName();
                    if (implicit.contains(oldName) || moveSrc.contains(oldName) || newEntries.contains(oldName)) continue;
                    if (_debug) {
                        System.out.println("deleted.add " + oldName);
                    }
                    deleted.add(oldName);
                }
            }
            if (_debug) {
                String newName;
                entries = moved.keySet().iterator();
                if (entries != null) {
                    System.out.println("MOVED MAP!!!");
                    while (entries.hasNext()) {
                        newName = (String)entries.next();
                        oldName = (String)moved.get(newName);
                        System.out.println("key is " + newName + " value is " + oldName);
                    }
                }
                if ((entries = implicit.iterator()) != null) {
                    System.out.println("IMOVE MAP!!!");
                    while (entries.hasNext()) {
                        newName = (String)entries.next();
                        System.out.println("key is " + newName);
                    }
                }
            }
            System.out.println("Creating jar diff with BEST_COMPRESSION");
            JarOutputStream jos = new JarOutputStream(os){};
            JarDiff.createIndex(jos, deleted, moved);
            entries = newEntries.iterator();
            if (entries != null) {
                while (entries.hasNext()) {
                    String newName = (String)entries.next();
                    if (_debug) {
                        System.out.println("New File: " + newName);
                    }
                    JarDiff.writeEntry(jos, newJar.getEntryByName(newName), newJar);
                }
            }
            jos.finish();
            jos.close();
        }
        catch (IOException ioE) {
            throw ioE;
        }
        finally {
            try {
                oldJar.getJarFile().close();
            }
            catch (IOException iOException) {}
            try {
                newJar.getJarFile().close();
            }
            catch (IOException iOException) {}
        }
        long ts2 = System.currentTimeMillis();
        System.out.println("Created jardiff patch in " + (ts2 - ts) + " ms.");
    }

    private static void createIndex(JarOutputStream jos, List oldEntries, Map movedMap) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write("version 1.0");
        writer.write("\r\n");
        for (int counter = 0; counter < oldEntries.size(); ++counter) {
            String name = (String)oldEntries.get(counter);
            writer.write("remove");
            writer.write(" ");
            JarDiff.writeEscapedString(writer, name);
            writer.write("\r\n");
        }
        Iterator names = movedMap.keySet().iterator();
        if (names != null) {
            while (names.hasNext()) {
                String newName = (String)names.next();
                String oldName = (String)movedMap.get(newName);
                writer.write("move");
                writer.write(" ");
                JarDiff.writeEscapedString(writer, oldName);
                writer.write(" ");
                JarDiff.writeEscapedString(writer, newName);
                writer.write("\r\n");
            }
        }
        JarEntry je = new JarEntry("META-INF/INDEX.JD");
        String indexStr = writer.toString();
        byte[] bytes = indexStr.getBytes("UTF-8");
        writer.close();
        jos.putNextEntry(je);
        jos.write(bytes, 0, bytes.length);
    }

    private static void writeEscapedString(Writer writer, String string) throws IOException {
        int index = 0;
        int last = 0;
        char[] chars = null;
        while ((index = string.indexOf(32, index)) != -1) {
            if (last != index) {
                if (chars == null) {
                    chars = string.toCharArray();
                }
                writer.write(chars, last, index - last);
            }
            last = index++;
            writer.write(92);
        }
        if (last != 0) {
            writer.write(chars, last, chars.length - last);
        } else {
            writer.write(string);
        }
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry, JarFile2 file) throws IOException {
        JarDiff.writeEntry(jos, entry, file.getJarFile().getInputStream(entry));
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry, InputStream data) throws IOException {
        jos.putNextEntry(entry);
        byte[] newBytes = new byte[2048];
        try {
            int size = data.read(newBytes);
            while (size != -1) {
                jos.write(newBytes, 0, size);
                size = data.read(newBytes);
            }
        }
        catch (IOException ioE) {
            throw ioE;
        }
        finally {
            try {
                data.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void showHelp() {
        System.out.println("JarDiff: [-nonminimal (for backward compatibility with 1.0.1/1.0] [-creatediff | -applydiff] [-output file] old.jar new.jar");
    }

    public static void main(String[] args) throws Exception {
        File oldJar = new File("/tmp/anahata-mapacho-cache/org.projectlombok-lombok__V1.14.4.jar");
        File newJar = new File("/tmp/anahata-mapacho-cache/org.projectlombok-lombok__V1.16.10.jar");
        File patch1 = new File("/tmp/anahata-mapacho-cache/jardiff1.jar");
        File newJar2 = new File("/tmp/anahata-mapacho-cache/patched.jar");
        File patch2 = new File("/tmp/anahata-mapacho-cache/jardiff2.jar");
        File patch3 = new File("/tmp/anahata-mapacho-cache/jardiff3.jar");
        try {
            JarDiff.createPatch(oldJar, newJar, new FileOutputStream(patch1), true);
            System.out.println("Patch created");
            new JarDiffPatcher().applyPatch(null, oldJar.getAbsolutePath(), patch1.getAbsolutePath(), new FileOutputStream(newJar2));
            JarDiff.createPatch(newJar2, newJar, new FileOutputStream(patch2), true);
            JarDiff.createPatch(newJar, newJar2, new FileOutputStream(patch3), true);
            System.out.println("Ready");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class JarFile2 {
        private JarFile _jar;
        private List _entries;
        private HashMap _nameToEntryMap;
        private HashMap _crcToEntryMap;

        public JarFile2(String path) throws IOException {
            this._jar = new JarFile(new File(path));
            this.index();
        }

        public JarFile getJarFile() {
            return this._jar;
        }

        public Iterator getJarEntries() {
            return this._entries.iterator();
        }

        public JarEntry getEntryByName(String name) {
            return (JarEntry)this._nameToEntryMap.get(name);
        }

        private boolean differs(InputStream oldIS, InputStream newIS) throws IOException {
            int newSize = 0;
            int total = 0;
            boolean retVal = false;
            byte[] newBytes = new byte[2048];
            byte[] oldBytes = new byte[2048];
            try {
                block13: while (newSize != -1) {
                    int oldSize;
                    newSize = newIS.read(newBytes);
                    if (newSize != (oldSize = oldIS.read(oldBytes))) {
                        if (_debug) {
                            System.out.println("\tread sizes differ: " + newSize + " " + oldSize + " total " + total);
                        }
                        retVal = true;
                        break;
                    }
                    if (newSize <= 0) continue;
                    while (--newSize >= 0) {
                        ++total;
                        if (newBytes[newSize] != oldBytes[newSize]) {
                            if (_debug) {
                                System.out.println("\tbytes differ at " + total);
                            }
                            retVal = true;
                            continue block13;
                        }
                        if (retVal) continue block13;
                        newSize = 0;
                    }
                }
            }
            catch (IOException ioE) {
                throw ioE;
            }
            finally {
                try {
                    oldIS.close();
                }
                catch (IOException iOException) {}
                try {
                    newIS.close();
                }
                catch (IOException iOException) {}
            }
            return retVal;
        }

        public String getBestMatch(JarFile2 file, JarEntry entry) throws IOException {
            if (this.contains(file, entry)) {
                return entry.getName();
            }
            return this.hasSameContent(file, entry);
        }

        public boolean contains(JarFile2 f, JarEntry e) throws IOException {
            InputStream newIS;
            JarEntry thisEntry = this.getEntryByName(e.getName());
            if (thisEntry == null) {
                return false;
            }
            if (thisEntry.getCrc() != e.getCrc()) {
                return false;
            }
            InputStream oldIS = this.getJarFile().getInputStream(thisEntry);
            boolean retValue = this.differs(oldIS, newIS = f.getJarFile().getInputStream(e));
            return !retValue;
        }

        public String hasSameContent(JarFile2 file, JarEntry entry) throws IOException {
            LinkedList ll;
            ListIterator li;
            String thisName = null;
            Long crcL = new Long(entry.getCrc());
            if (this._crcToEntryMap.containsKey(crcL) && (li = (ll = (LinkedList)this._crcToEntryMap.get(crcL)).listIterator(0)) != null) {
                while (li.hasNext()) {
                    InputStream newIS;
                    JarEntry thisEntry = (JarEntry)li.next();
                    InputStream oldIS = this.getJarFile().getInputStream(thisEntry);
                    if (this.differs(oldIS, newIS = file.getJarFile().getInputStream(entry))) continue;
                    thisName = thisEntry.getName();
                    return thisName;
                }
            }
            return thisName;
        }

        private void index() throws IOException {
            Enumeration<JarEntry> entries = this._jar.entries();
            this._nameToEntryMap = new HashMap();
            this._crcToEntryMap = new HashMap();
            this._entries = new ArrayList();
            if (_debug) {
                System.out.println("indexing: " + this._jar.getName());
            }
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    LinkedList ll;
                    JarEntry entry = entries.nextElement();
                    long crc = entry.getCrc();
                    Long crcL = new Long(crc);
                    if (_debug) {
                        // empty if block
                    }
                    this._nameToEntryMap.put(entry.getName(), entry);
                    this._entries.add(entry);
                    if (this._crcToEntryMap.containsKey(crcL)) {
                        ll = (LinkedList)this._crcToEntryMap.get(crcL);
                        ll.add(entry);
                        this._crcToEntryMap.put(crcL, ll);
                        continue;
                    }
                    ll = new LinkedList();
                    ll.add(entry);
                    this._crcToEntryMap.put(crcL, ll);
                }
            }
        }
    }
}

