/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.common.os;

public final class OSUtils {
    private static final String SYSPROP_OS_NAME = "os.name";
    private static final String SYSPROP_OS_USER_NAME = "user.name";
    private static final String SYSPROP_OS_USER_HOME = "user.home";
    private static final String OS_NAME_UNKNOWN = "unknown";
    private static final String OS_NAME_MAC_1 = "mac";
    private static final String OS_NAME_MAC_2 = "darwin";
    private static final String OS_NAME_WINDOWS = "windows";
    private static final String OS_NAME_LINUX = "linux";

    public static boolean isWindows() {
        String osName = OSUtils.getOsName();
        return osName.startsWith(OS_NAME_WINDOWS);
    }

    public static boolean isMac() {
        return OSUtils.isMac(OSUtils.getOsName());
    }

    public static boolean isMac(String osName) {
        return osName.toLowerCase().startsWith(OS_NAME_MAC_1) || osName.toLowerCase().startsWith(OS_NAME_MAC_2);
    }

    public static boolean isLinux() {
        String osName = OSUtils.getOsName();
        return osName.startsWith(OS_NAME_LINUX);
    }

    private static String getOsName() {
        return System.getProperty(SYSPROP_OS_NAME, OS_NAME_UNKNOWN).toLowerCase();
    }

    public static String getUserName() {
        return System.getProperties().getProperty(SYSPROP_OS_USER_NAME);
    }

    public static String getUserHome() {
        return System.getProperties().getProperty(SYSPROP_OS_USER_HOME);
    }

    private OSUtils() {
    }
}

