/*
 * Decompiled with CFR 0.152.
 */
package uno.anahata.mapacho.common.runtime;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import uno.anahata.mapacho.common.os.OSUtils;

public class JRE
implements Serializable {
    private String ver;
    private String build;
    private String hash;
    private String os = "";
    private String arch = "";

    public String getArch() {
        return this.arch;
    }

    public boolean is64bit() {
        return this.getArch().contains("64");
    }

    public String getOsSimple() {
        String o = OSUtils.isMac(this.os) ? "macosx" : this.os.toLowerCase();
        return StringUtils.isBlank((CharSequence)o) ? "windows" : o;
    }

    public String getArchSimple() {
        return this.is64bit() ? "x64" : "x32";
    }

    public String getEncodedName() {
        String simpleArch = this.getArchSimple();
        String name = this.ver + "-b" + this.build + "-" + this.getOsSimple() + "-" + simpleArch;
        return name;
    }

    public File getLocation(File repo) {
        File location = new File(repo, this.getEncodedName());
        return location;
    }

    public File getExecutable(File repo) {
        String suffix = OSUtils.isWindows() ? ".exe" : "";
        String preffix = OSUtils.isMac(this.os) ? "Contents" + File.separator + "Home" + File.separator : "";
        preffix = preffix + "bin" + File.separator;
        return new File(this.getLocation(repo), preffix + "java" + suffix);
    }

    public String getOracleWebsiteDownloadURL() {
        String urlString;
        String os = this.getOsSimple();
        String arch = this.is64bit() ? "x64" : "i586";
        String h = "";
        if (!StringUtils.isBlank((CharSequence)this.hash)) {
            h = "/" + this.hash;
        }
        if (!StringUtils.isBlank((CharSequence)this.hash) && this.hash.startsWith("url-")) {
            String host = this.hash.split("-")[1];
            String jver = this.hash.split("-")[2];
            urlString = String.format("http://%s/jre-%s-%s-%s.tar.gz", host, jver, os, arch);
        } else {
            urlString = "http://download.oracle.com/otn-pub/java/jdk/" + this.getVer() + "-b" + this.getBuild() + h + "/jre-" + this.getVer() + "-" + os + "-" + arch + ".tar.gz";
        }
        return urlString;
    }

    public boolean matches() {
        return System.getProperty("os.name").toLowerCase().startsWith(this.os.toLowerCase());
    }

    public String toString() {
        return "JRE{ver=" + this.ver + ", build=" + this.build + ", hash=" + this.hash + ", os=" + this.os + ", arch=" + this.arch + '}' + " downloadURL=" + this.getOracleWebsiteDownloadURL();
    }

    public String getVer() {
        return this.ver;
    }

    public String getBuild() {
        return this.build;
    }

    public String getHash() {
        return this.hash;
    }

    public String getOs() {
        return this.os;
    }

    public void setVer(String ver) {
        this.ver = ver;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JRE)) {
            return false;
        }
        JRE other = (JRE)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ver = this.getVer();
        String other$ver = other.getVer();
        if (this$ver == null ? other$ver != null : !this$ver.equals(other$ver)) {
            return false;
        }
        String this$build = this.getBuild();
        String other$build = other.getBuild();
        if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$os = this.getOs();
        String other$os = other.getOs();
        if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
            return false;
        }
        String this$arch = this.getArch();
        String other$arch = other.getArch();
        return !(this$arch == null ? other$arch != null : !this$arch.equals(other$arch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JRE;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ver = this.getVer();
        result = result * 59 + ($ver == null ? 43 : $ver.hashCode());
        String $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : $os.hashCode());
        String $arch = this.getArch();
        result = result * 59 + ($arch == null ? 43 : $arch.hashCode());
        return result;
    }
}

