/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.engines;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.JmeterDsl;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;
import us.abstracta.jmeter.javadsl.core.engines.TestStopper;
import us.abstracta.jmeter.javadsl.core.listeners.autostop.AutoStopTestBean;
import us.abstracta.jmeter.javadsl.engines.BaseRemoteEngineApiClient;

public abstract class BaseRemoteEngine<C extends BaseRemoteEngineApiClient, S extends TestPlanStats>
implements DslJmeterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRemoteEngine.class);
    protected C apiClient;

    /*
     * Loose catch block
     */
    public TestPlanStats run(DslTestPlan testPlan) throws IOException, InterruptedException, TimeoutException {
        File jmxFile = Files.createTempDirectory("jmeter-dsl", new FileAttribute[0]).resolve("test.jmx").toFile();
        try {
            try (C cli = this.buildClient();){
                this.apiClient = cli;
                JmeterEnvironment env = new JmeterEnvironment();
                BuildTreeContext context = BuildTreeContext.buildRemoteExecutionContext();
                context.setTestStopper(this.buildTestStopper());
                HashTree tree = this.buildTree(testPlan, context);
                this.saveTestPlanTo(jmxFile, tree, env);
                S s = this.run(jmxFile, tree, context);
                return s;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (jmxFile.delete()) {
                jmxFile.getParentFile().delete();
            }
        }
    }

    protected abstract S run(File var1, HashTree var2, BuildTreeContext var3) throws IOException, InterruptedException, TimeoutException;

    protected abstract C buildClient();

    protected TestStopper buildTestStopper() {
        return null;
    }

    protected HashTree buildTree(DslTestPlan testPlan, BuildTreeContext context) {
        ListedHashTree ret = new ListedHashTree();
        context.buildTreeFor((DslTestElement)testPlan, (HashTree)ret);
        context.getVisualizers().forEach((v, e) -> LOG.warn("This engine does not currently support displaying visualizers. Ignoring {}.", (Object)v.getClass().getSimpleName()));
        return ret;
    }

    private void saveTestPlanTo(File jmxFile, HashTree tree, JmeterEnvironment env) throws IOException {
        try (FileOutputStream output = new FileOutputStream(jmxFile.getPath());){
            env.saveTree(tree, output);
        }
    }

    protected List<File> findDependencies(HashTree tree, BuildTreeContext ctx) {
        HashMap ret = new HashMap();
        this.findDependencies(tree, ctx, ret);
        return new ArrayList<File>(ret.values());
    }

    private void findDependencies(HashTree tree, BuildTreeContext ctx, Map<Class<?>, File> deps) {
        for (Object elem : tree.list()) {
            if (deps.containsKey(elem.getClass())) break;
            if (elem instanceof AutoStopTestBean) {
                this.addDependency(elem, deps);
                if (ctx.getTestStopper() == null) continue;
                this.addDependency(ctx.getTestStopper(), deps);
                continue;
            }
            if (elem.getClass().getPackage().getName().startsWith(JmeterDsl.class.getPackage().getName())) {
                this.addDependency(elem, deps);
                continue;
            }
            this.findDependencies(tree.get(elem), ctx, deps);
        }
    }

    private void addDependency(Object elem, Map<Class<?>, File> deps) {
        deps.put(elem.getClass(), this.getClassJarPath(elem.getClass()));
    }

    private File getClassJarPath(Class<?> theClass) {
        try {
            File[] jars;
            File ret = new File(theClass.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (ret.isDirectory() && ret.getPath().matches(".*[/\\\\]target[/\\\\](test-)?classes$") && (jars = new File(ret.getParent()).listFiles((dir, name) -> name.endsWith(".jar") && !name.endsWith("-tests.jar") && !name.endsWith("-javadoc.jar"))).length >= 1) {
                ret = jars[0];
            }
            return ret;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isAutoStoppableTest(HashTree tree) {
        for (Object elem : tree.list()) {
            if (elem instanceof AutoStopTestBean) {
                return true;
            }
            if (!this.isAutoStoppableTest(tree.get(elem))) continue;
            return true;
        }
        return false;
    }

    protected ThreadGroup extractFirstThreadGroup(HashTree tree) {
        HashTree testPlanTree = tree.getTree(tree.list().iterator().next());
        return testPlanTree.list().stream().filter(e -> e.getClass() == ThreadGroup.class).findFirst().orElse(null);
    }

    protected boolean hasTimedOut(Duration timeout, Instant start) {
        return Duration.between(start, Instant.now()).compareTo(timeout) >= 0;
    }

    protected String prettyDuration(Duration duration) {
        String ret = duration.toString().substring(2);
        ret = ret.replaceAll("[HMS]", "$0 ").toLowerCase();
        return ret.substring(0, ret.length() - 1);
    }
}

