/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.engines;

import java.time.Duration;
import us.abstracta.jmeter.javadsl.core.stats.TimeMetricSummary;

public class RemoteEngineTimeMetricSummary
implements TimeMetricSummary {
    protected final Duration min;
    protected final Duration max;
    protected final Duration mean;
    protected final Duration median;
    protected final Duration percentile90;
    protected final Duration percentile95;
    protected final Duration percentile99;

    public RemoteEngineTimeMetricSummary(long min, long max, double mean, double median, double percentile90, double percentile95, double percentile99) {
        this.min = Duration.ofMillis(min);
        this.max = Duration.ofMillis(max);
        this.mean = this.double2Duration(mean);
        this.median = this.double2Duration(median);
        this.percentile90 = this.double2Duration(percentile90);
        this.percentile95 = this.double2Duration(percentile95);
        this.percentile99 = this.double2Duration(percentile99);
    }

    private Duration double2Duration(double millis) {
        return Duration.ofMillis(Math.round(millis));
    }

    public Duration min() {
        return this.min;
    }

    public Duration max() {
        return this.max;
    }

    public Duration mean() {
        return this.mean;
    }

    public Duration median() {
        return this.median;
    }

    public Duration perc90() {
        return this.percentile90;
    }

    public Duration perc95() {
        return this.percentile95;
    }

    public Duration perc99() {
        return this.percentile99;
    }
}

