/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.bridge.serialization.constructs;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import us.abstracta.jmeter.javadsl.bridge.serialization.BridgedObjectConstructor;
import us.abstracta.jmeter.javadsl.bridge.serialization.BuilderMethod;
import us.abstracta.jmeter.javadsl.bridge.serialization.TestElementConstructorException;
import us.abstracta.jmeter.javadsl.bridge.serialization.constructs.BaseBridgedObjectConstruct;

public class BridgedObjectConstruct
extends BaseBridgedObjectConstruct {
    private static final Map<Class<?>, Function<String, Object>> PARSERS = BridgedObjectConstruct.solveParsers();
    private final BridgedObjectConstructor constructor;
    private final String tag;
    private final List<BuilderMethod> builders;

    public BridgedObjectConstruct(BridgedObjectConstructor constructor, String tag, List<BuilderMethod> builders) {
        this.constructor = constructor;
        this.tag = tag;
        this.builders = builders;
        builders.sort(Comparator.comparing(b -> b.getParameters().length).reversed());
    }

    private static Map<Class<?>, Function<String, Object>> solveParsers() {
        HashMap ret = new HashMap();
        ret.put(Integer.TYPE, Integer::parseInt);
        ret.put(Long.TYPE, Long::parseLong);
        ret.put(Boolean.TYPE, Boolean::parseBoolean);
        ret.put(Double.TYPE, Double::parseDouble);
        ret.put(Duration.class, Duration::parse);
        ret.put(String.class, s -> s);
        return ret;
    }

    public Object construct(Node node) {
        Map<String, Node> nodeProperties = BridgedObjectConstruct.getNodeProperties(node, this.tag);
        Object ret = this.buildTestElement(nodeProperties, node);
        this.buildPropertiesFromList(nodeProperties.remove("_propsList"), ret);
        nodeProperties.forEach((propName, propNode) -> this.callPropertyMethod((String)propName, (Node)propNode, ret));
        return ret;
    }

    private Object buildTestElement(Map<String, Node> nodeProperties, Node node) {
        for (BuilderMethod m : this.builders) {
            LinkedHashMap<Parameter, Optional<Node>> paramNodes = this.extractParametersNodes(m, nodeProperties);
            if (!this.allParametersFound(paramNodes)) continue;
            try {
                paramNodes.keySet().forEach(p -> {
                    Node cfr_ignored_0 = (Node)nodeProperties.remove(p.getName());
                });
                Object[] args = this.buildBuilderArguments(paramNodes);
                return m.invoke(args);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TestElementConstructorException(this.tag, node, "could not find a proper builder");
    }

    private LinkedHashMap<Parameter, Optional<Node>> extractParametersNodes(BuilderMethod m, Map<String, Node> properties) {
        return Arrays.stream(m.getParameters()).collect(Collectors.toMap(p -> p, p -> Optional.ofNullable(properties.get(p.getName())), (u, v) -> u, LinkedHashMap::new));
    }

    private boolean allParametersFound(Map<Parameter, Optional<Node>> paramNodes) {
        return paramNodes.values().stream().allMatch(Optional::isPresent);
    }

    private Object[] buildBuilderArguments(Map<Parameter, Optional<Node>> paramNodes) {
        return paramNodes.entrySet().stream().map(e -> this.constructParameter((Node)((Optional)e.getValue()).get(), (Parameter)e.getKey())).toArray(Object[]::new);
    }

    private Object constructParameter(Node node, Parameter parameter) {
        Class<?> paramType = parameter.getType();
        Function<String, Object> parser = PARSERS.get(paramType);
        if (parser != null && node instanceof ScalarNode) {
            return parser.apply(((ScalarNode)node).getValue());
        }
        if (paramType.isEnum() && node instanceof ScalarNode) {
            return Enum.valueOf(paramType, ((ScalarNode)node).getValue());
        }
        Object ret = this.constructor.constructObject(node);
        if (paramType.isAssignableFrom(ret.getClass())) {
            return ret;
        }
        if (paramType.isArray() && ret instanceof List) {
            List list = (List)ret;
            Object arr = Array.newInstance(parameter.getType().getComponentType(), list.size());
            int i = 0;
            for (Object elem : list) {
                Array.set(arr, i++, elem);
            }
            return arr;
        }
        if (paramType.isArray() && paramType.getComponentType().isAssignableFrom(ret.getClass())) {
            Object arr = Array.newInstance(parameter.getType().getComponentType(), 1);
            Array.set(arr, 0, ret);
            return arr;
        }
        throw new TestElementConstructorException(this.tag, node, String.format("expected a %s but got a %s", paramType.getName(), ret.getClass().getName()));
    }

    private void buildPropertiesFromList(Node props, Object ret) {
        if (props == null) {
            return;
        }
        SequenceNode propsList = BridgedObjectConstruct.castNode(props, SequenceNode.class, "list", this.tag);
        propsList.getValue().forEach(s -> {
            String propertyName = s.getTag().getValue().substring(1);
            this.callPropertyMethod(propertyName, (Node)s, ret);
        });
    }

    private void callPropertyMethod(String propName, Node propNode, Object ret) {
        Method propMethod = this.findPropertyMethod(propName, propNode, ret);
        try {
            Object[] args = this.buildArgs(propMethod, propNode);
            propMethod.invoke(ret, args);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Method findPropertyMethod(String propName, Node propNode, Object testElement) {
        List candidates = Stream.of(testElement.getClass().getMethods()).filter(m -> propName.equals(m.getName())).sorted((m1, m2) -> {
            Class<?> m2Class;
            Class<?> m1Class = m1.getReturnType();
            return m1Class == (m2Class = m2.getReturnType()) ? 0 : (m1Class.isAssignableFrom(m2Class) ? 1 : -1);
        }).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            throw new TestElementConstructorException(this.tag, propNode, "could not find a method for setting property " + propName);
        }
        return candidates.stream().filter(m -> m.getParameters().length >= 1 && Arrays.stream(m.getParameters()).allMatch(p -> String.class.isAssignableFrom(p.getType()))).findFirst().orElseGet(() -> candidates.stream().filter(m -> m.getParameters().length == 1 && Boolean.TYPE.isAssignableFrom(m.getParameters()[0].getType())).findFirst().orElseGet(() -> (Method)candidates.get(0)));
    }

    private Object[] buildArgs(Method propMethod, Node propNode) {
        Parameter[] params = propMethod.getParameters();
        if (params.length == 0) {
            return new Object[0];
        }
        if (params.length == 1) {
            return new Object[]{this.constructParameter(this.extractSingleArgNode(propNode, params[0]), params[0])};
        }
        Map<String, Node> props = BridgedObjectConstruct.getNodeProperties(propNode, propNode.getTag().getValue());
        return Arrays.stream(propMethod.getParameters()).map(p -> this.constructParameter((Node)props.get(p.getName()), (Parameter)p)).toArray();
    }

    private Node extractSingleArgNode(Node propNode, Parameter param) {
        MappingNode mappingNode;
        if (propNode instanceof MappingNode && (mappingNode = (MappingNode)propNode).getValue().size() == 1 && ((ScalarNode)((NodeTuple)mappingNode.getValue().get(0)).getKeyNode()).getValue().equals(param.getName())) {
            return ((NodeTuple)mappingNode.getValue().get(0)).getValueNode();
        }
        return propNode;
    }
}

