/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.bridge.serialization.constructs;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.nodes.Node;
import us.abstracta.jmeter.javadsl.bridge.serialization.BridgedObjectConstructor;
import us.abstracta.jmeter.javadsl.bridge.serialization.BuilderMethod;
import us.abstracta.jmeter.javadsl.bridge.serialization.TestElementConstructorException;
import us.abstracta.jmeter.javadsl.bridge.serialization.constructs.BridgedObjectConstruct;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.engines.EmbeddedJmeterEngine;

public class EngineConstruct
extends AbstractConstruct {
    private final BridgedObjectConstructor constructor;

    public EngineConstruct(BridgedObjectConstructor constructor) {
        this.constructor = constructor;
    }

    public Object construct(Node node) {
        Class<? extends DslJmeterEngine> engineClass = this.findEngineClass(node);
        return new BridgedObjectConstruct(this.constructor, node.getTag().getValue().substring(1), Arrays.stream(engineClass.getConstructors()).map(x$0 -> new ConstructorBuilderMethod((Constructor)x$0)).collect(Collectors.toList())).construct(node);
    }

    private Class<? extends DslJmeterEngine> findEngineClass(Node node) {
        String tag = node.getTag().getValue().substring(1);
        if ("embeddedJmeterEngine".equals(tag)) {
            return EmbeddedJmeterEngine.class;
        }
        try {
            return Class.forName("us.abstracta.jmeter.javadsl." + tag);
        }
        catch (ClassNotFoundException e) {
            throw new TestElementConstructorException(tag, node, "could not find the engine class. Check that is included in classpath.");
        }
    }

    private static class ConstructorBuilderMethod
    implements BuilderMethod {
        private final Constructor<?> method;

        private ConstructorBuilderMethod(Constructor<?> method) {
            this.method = method;
        }

        @Override
        public Object invoke(Object ... args) throws ReflectiveOperationException {
            return this.method.newInstance(args);
        }

        @Override
        public Parameter[] getParameters() {
            return this.method.getParameters();
        }
    }
}

