/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import us.abstracta.wiresham.ConnectionClosedException;
import us.abstracta.wiresham.Flow;
import us.abstracta.wiresham.FlowConnection;
import us.abstracta.wiresham.FlowConnectionProvider;
import us.abstracta.wiresham.PacketStep;

public class ConnectionFlowDriver
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionFlowDriver.class);
    private final FlowConnectionProvider connectionProvider;
    private final Queue<PacketStep> flowSteps;
    private final int portArgument;

    public ConnectionFlowDriver(FlowConnectionProvider connectionProvider, Flow flow, int portArgument) {
        this.portArgument = portArgument;
        this.flowSteps = new LinkedList<PacketStep>(flow.getSteps());
        this.connectionProvider = connectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            PacketStep first = this.flowSteps.peek();
            int previousPort = first == null || first.getPort() == null ? this.portArgument : first.getPort();
            LOG.info("starting new flow on {}", (Object)previousPort);
            while (!this.flowSteps.isEmpty()) {
                PacketStep step = this.flowSteps.poll();
                if (step.getPort() != null && step.getPort() != previousPort) {
                    LOG.info("changing to connections on port {}", (Object)step.getPort());
                    previousPort = step.getPort();
                }
                FlowConnection flowConnection = this.connectionProvider.get(previousPort);
                step.process(flowConnection);
            }
            LOG.info("flow completed!");
        }
        catch (ConnectionClosedException e) {
            LOG.info("Connection closed by client while waiting for client packet");
            if (e.getDiscardedPacket().getBytes().length > 0) {
                LOG.debug("Discarding client packet {}", (Object)e.getDiscardedPacket(), (Object)e);
            }
        }
        catch (IOException e) {
            if (e.getMessage().contains("Socket is closed")) {
                LOG.trace("Received expected exception when server socket has been closed", (Throwable)e);
            } else {
                LOG.error("Problem while processing requests from client. Closing connection.", (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            LOG.trace("The thread has been interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error("Problem while waiting for socket to be created", (Throwable)e);
        }
        finally {
            try {
                this.closeFlowConnections();
            }
            catch (IOException e) {
                LOG.error("Problem while releasing sockets", (Throwable)e);
            }
            MDC.clear();
        }
    }

    public FlowConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public void closeFlowConnections() throws IOException {
        this.connectionProvider.closeConnections();
    }
}

