/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.TcpPacket;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import us.abstracta.wiresham.PacketStep;
import us.abstracta.wiresham.ReceivePacketStep;
import us.abstracta.wiresham.SendPacketStep;

public class Flow {
    private static final Map<String, Class<?>> YAML_TAGS = ImmutableMap.builder().put((Object)"!server", SendPacketStep.class).put((Object)"!client", ReceivePacketStep.class).build();
    private static final JsonPointer WIRESHARK_LAYERS_PATH = JsonPointer.valueOf((String)"/_source/layers");
    private static final JsonPointer WIRESHARK_TCP_PAYLOAD_PATH = JsonPointer.valueOf((String)"/tcp/tcp.payload");
    private static final JsonPointer WIRESHARK_SOURCE_IP_PATH = JsonPointer.valueOf((String)"/ip/ip.src");
    private static final JsonPointer WIRESHARK_SOURCE_PORT_PATH = JsonPointer.valueOf((String)"/tcp/tcp.srcport");
    private static final JsonPointer WIRESHARK_DESTINE_PORT_PATH = JsonPointer.valueOf((String)"/tcp/tcp.dstport");
    private static final JsonPointer WIRESHARK_TIME_DELTA_PATH = JsonPointer.valueOf((String)"/frame/frame.time_delta_displayed");
    private static final String IP_PORT_SEPARATOR = ":";
    private final List<PacketStep> steps;

    @VisibleForTesting
    public Flow(List<PacketStep> steps) {
        this.steps = steps;
    }

    public List<PacketStep> getSteps() {
        return this.steps;
    }

    public String toString() {
        return this.steps.toString();
    }

    public static Flow fromWiresharkJsonDump(File file, String serverAddress) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(file);
        return new Flow(StreamSupport.stream(json.spliterator(), false).filter(packet -> !packet.at(WIRESHARK_LAYERS_PATH).at(WIRESHARK_TCP_PAYLOAD_PATH).asText().isEmpty()).map(packet -> {
            JsonNode layers = packet.at(WIRESHARK_LAYERS_PATH);
            String sourceIp = layers.at(WIRESHARK_SOURCE_IP_PATH).asText();
            String sourcePort = layers.at(WIRESHARK_SOURCE_PORT_PATH).asText();
            String hexDump = layers.at(WIRESHARK_TCP_PAYLOAD_PATH).asText().replace(IP_PORT_SEPARATOR, "");
            long timeDeltaMillis = Long.parseLong(layers.at(WIRESHARK_TIME_DELTA_PATH).asText().replace(".", "")) / 1000000L;
            return Flow.isServerAddress(sourceIp, sourcePort, serverAddress) ? new SendPacketStep(hexDump, timeDeltaMillis, Integer.parseInt(sourcePort)) : new ReceivePacketStep(hexDump, Integer.parseInt(layers.at(WIRESHARK_DESTINE_PORT_PATH).asText()));
        }).collect(Collectors.toList()));
    }

    private static boolean isServerAddress(String sourceIp, String sourcePort, String serverAddress) {
        return serverAddress.contains(IP_PORT_SEPARATOR) && (sourceIp + IP_PORT_SEPARATOR + sourcePort).equals(serverAddress) || serverAddress.equals(sourceIp);
    }

    public static Flow fromPcap(File file, String serverAddress, String filter) throws IOException {
        ArrayList<PacketStep> steps = new ArrayList<PacketStep>();
        try {
            PcapHandle pcap = Pcaps.openOffline((String)file.getAbsolutePath());
            Throwable throwable = null;
            try {
                try {
                    if (filter != null) {
                        pcap.setFilter(filter, BpfProgram.BpfCompileMode.OPTIMIZE);
                    }
                    long lastTimeMillis = 0L;
                    while (true) {
                        Packet payload;
                        Packet p;
                        if (!(p = pcap.getNextPacketEx()).contains(TcpPacket.class) || (payload = ((TcpPacket)p.get(TcpPacket.class)).getPayload()) == null) {
                            continue;
                        }
                        IpV4Packet ipV4Packet = (IpV4Packet)p.get(IpV4Packet.class);
                        String sourceIp = ipV4Packet.getHeader().getSrcAddr().getHostAddress();
                        int sourcePort = ((TcpPacket)ipV4Packet.getPayload().get(TcpPacket.class)).getHeader().getSrcPort().valueAsInt();
                        String hexDump = BaseEncoding.base16().encode(payload.getRawData());
                        long timeMillis = pcap.getTimestamp().getTime();
                        long timeDeltaMillis = lastTimeMillis > 0L ? timeMillis - lastTimeMillis : 0L;
                        lastTimeMillis = timeMillis;
                        steps.add(Flow.isServerAddress(sourceIp, String.valueOf(sourcePort), serverAddress) ? new SendPacketStep(hexDump, timeDeltaMillis, sourcePort) : new ReceivePacketStep(hexDump, ((TcpPacket)ipV4Packet.getPayload().get(TcpPacket.class)).getHeader().getDstPort().valueAsInt()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (pcap != null) {
                    if (throwable != null) {
                        try {
                            pcap.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        pcap.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (EOFException pcap) {
        }
        catch (TimeoutException | NotOpenException | PcapNativeException e) {
            throw new IOException("Problem reading file " + file, e);
        }
        return new Flow(steps);
    }

    public static Flow fromYml(File ymlFile) throws FileNotFoundException {
        List packets = (List)new Yaml((BaseConstructor)Flow.buildYamlConstructor()).load((InputStream)new FileInputStream(ymlFile));
        return new Flow(packets);
    }

    public static Flow fromYmlStream(InputStream stream) {
        List packets = (List)new Yaml((BaseConstructor)Flow.buildYamlConstructor()).load(stream);
        return new Flow(packets);
    }

    private static Constructor buildYamlConstructor() {
        Constructor constructor = new Constructor();
        YAML_TAGS.forEach((tag, clazz) -> constructor.addTypeDescription(new TypeDescription(clazz, tag)));
        return constructor;
    }

    public void saveYml(File ymlFile) throws IOException {
        new Yaml(Flow.buildYamlRepresenter()).dump(this.steps, (Writer)new FileWriter(ymlFile));
    }

    private static Representer buildYamlRepresenter() {
        Representer representer = new Representer(){
            private int previousPort = 0;

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                if (property.getType() == Long.TYPE && (Long)propertyValue == 0L) {
                    return null;
                }
                if (property.getType() == Integer.TYPE) {
                    if ((Integer)propertyValue == 0 || this.previousPort == (Integer)propertyValue) {
                        return null;
                    }
                    this.previousPort = (Integer)propertyValue;
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        YAML_TAGS.forEach((tag, clazz) -> representer.addClassTag(clazz, new Tag(tag)));
        return representer;
    }

    public Flow reversed() {
        return new Flow(this.steps.stream().map(s -> s instanceof SendPacketStep ? new ReceivePacketStep(s.data.toString()) : new SendPacketStep(s.data.toString(), 0L)).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Flow flow = (Flow)o;
        return Objects.equals(this.steps, flow.steps);
    }

    public int hashCode() {
        return Objects.hash(this.steps);
    }

    public int getPortCount() {
        return this.getPorts().size();
    }

    public List<Integer> getPorts() {
        return this.steps.stream().filter(p -> p instanceof SendPacketStep).map(PacketStep::getPort).distinct().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

