/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.wiresham.ConnectionClosedException;
import us.abstracta.wiresham.Packet;

public class FlowConnection {
    private static final Logger LOG = LoggerFactory.getLogger(FlowConnection.class);
    private final Socket socket;
    private final ByteBuffer readBuffer;

    public FlowConnection(Socket socket, int readBufferSize) {
        this.socket = socket;
        this.readBuffer = ByteBuffer.allocate(readBufferSize);
        this.readBuffer.limit(0);
    }

    public void write(byte[] data) throws IOException {
        this.socket.getOutputStream().write(data);
    }

    public ByteBuffer read() throws IOException {
        if (!this.readBuffer.hasRemaining()) {
            LOG.trace("reading from socket");
            int count = this.socket.getInputStream().read(this.readBuffer.array(), this.readBuffer.position(), this.readBuffer.capacity() - this.readBuffer.position());
            if (count == -1) {
                throw new ConnectionClosedException(Packet.fromBytes(this.readBuffer.array(), 0, this.readBuffer.position()));
            }
            this.readBuffer.limit(this.readBuffer.position() + count);
            if (LOG.isTraceEnabled()) {
                LOG.trace("read from socket: {}", (Object)Packet.fromBytes(this.readBuffer.array(), this.readBuffer.position(), count));
            }
        }
        return this.readBuffer;
    }

    public void close() throws IOException {
        if (this.socket.isClosed()) {
            return;
        }
        this.socket.close();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }
}

