/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import com.google.common.io.BaseEncoding;
import java.util.Arrays;

public class Packet {
    private final byte[] bytes;

    private Packet(byte[] bytes) {
        this.bytes = bytes;
    }

    public static Packet fromHexDump(String hexDump) {
        return new Packet(BaseEncoding.base16().decode((CharSequence)hexDump.toUpperCase()));
    }

    public static Packet fromBytes(byte[] bytes, int offset, int length) {
        return new Packet(Arrays.copyOfRange(bytes, offset, offset + length));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Packet packet = (Packet)o;
        return Arrays.equals(this.bytes, packet.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return BaseEncoding.base16().encode(this.bytes);
    }
}

