/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.wiresham.FlowConnection;
import us.abstracta.wiresham.Packet;
import us.abstracta.wiresham.PacketStep;

public class ReceivePacketStep
extends PacketStep {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivePacketStep.class);

    public ReceivePacketStep() {
    }

    public ReceivePacketStep(String hexDump) {
        super(hexDump);
    }

    public ReceivePacketStep(String hexDump, int port) {
        super(hexDump, port);
    }

    @Override
    public void process(FlowConnection flowConnection) throws IOException {
        ByteBuffer dataBuffer = ByteBuffer.wrap(this.data.getBytes());
        LOG.debug("Waiting for {}", (Object)this.data);
        boolean receivedExpected = false;
        while (!receivedExpected) {
            ByteBuffer readBuffer = flowConnection.read();
            int foundPos = this.findDataInBuffer(dataBuffer, readBuffer);
            if (foundPos != -1) {
                if (foundPos != 0 && LOG.isTraceEnabled()) {
                    LOG.trace("ignoring received {}  before expected", (Object)Packet.fromBytes(readBuffer.array(), 0, foundPos));
                }
                LOG.debug("received expected {}", (Object)this.data);
                readBuffer.compact();
                readBuffer.flip();
                receivedExpected = true;
                continue;
            }
            if (readBuffer.limit() != readBuffer.capacity()) continue;
            int markedPosition = this.getMarkedPosition(readBuffer);
            if (markedPosition != -1) {
                int relativePos = readBuffer.position() - markedPosition + 1;
                readBuffer.compact();
                readBuffer.flip();
                readBuffer.position(1);
                readBuffer.mark();
                readBuffer.position(relativePos);
                continue;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("ignoring received {} while waiting for {}", (Object)Packet.fromBytes(readBuffer.array(), 0, readBuffer.limit()), (Object)this.data);
            }
            readBuffer.clear();
            readBuffer.limit(0);
        }
    }

    private int findDataInBuffer(ByteBuffer dataBuffer, ByteBuffer readBuffer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Searching for {} from {} in {} from {}", new Object[]{this.data, dataBuffer.position(), Packet.fromBytes(readBuffer.array(), 0, readBuffer.limit()), readBuffer.position()});
        }
        while (dataBuffer.hasRemaining() && readBuffer.hasRemaining()) {
            if (readBuffer.get() != dataBuffer.get()) {
                if (dataBuffer.position() != 1) {
                    LOG.trace("Finish match at {} and {}", (Object)(readBuffer.position() - 1), (Object)(dataBuffer.position() - 1));
                    readBuffer.reset();
                }
                dataBuffer.rewind();
                continue;
            }
            if (dataBuffer.position() != 1) continue;
            readBuffer.mark();
            LOG.trace("Start match at {}", (Object)(readBuffer.position() - 1));
        }
        if (!dataBuffer.hasRemaining()) {
            return this.getMarkedPosition(readBuffer) - 1;
        }
        return -1;
    }

    private int getMarkedPosition(ByteBuffer readBuffer) {
        int position = readBuffer.position();
        readBuffer.reset();
        int markedPosition = readBuffer.position();
        readBuffer.position(position);
        return markedPosition;
    }

    public String toString() {
        return "client: " + this.data;
    }
}

