/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.wiresham.FlowConnection;
import us.abstracta.wiresham.PacketStep;

public class SendPacketStep
extends PacketStep {
    private static final Logger LOG = LoggerFactory.getLogger(SendPacketStep.class);
    private long delayMillis;

    public SendPacketStep() {
    }

    public SendPacketStep(String hexDump, long delayMillis) {
        super(hexDump);
        this.delayMillis = delayMillis;
    }

    public SendPacketStep(String hexDump, long delayMillis, int port) {
        super(hexDump, port);
        this.delayMillis = delayMillis;
        this.port = port;
    }

    public long getDelayMillis() {
        return this.delayMillis;
    }

    public void setDelayMillis(long delayMillis) {
        this.delayMillis = delayMillis;
    }

    @Override
    public void process(FlowConnection connectionDriver) throws IOException, InterruptedException {
        LOG.debug("sending {} with {} millis delay", (Object)this.data, (Object)this.delayMillis);
        if (this.delayMillis > 0L) {
            Thread.sleep(this.delayMillis);
        }
        connectionDriver.write(this.data.getBytes());
    }

    public String toString() {
        return String.format("server: %s, delayMillis: %d, port: %d", this.data, this.delayMillis, this.port);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SendPacketStep that = (SendPacketStep)o;
        return this.port == that.port && this.delayMillis == that.delayMillis;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.port, this.delayMillis);
    }
}

