/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.wiresham.ConnectionFlowDriver;
import us.abstracta.wiresham.Flow;
import us.abstracta.wiresham.FlowConnection;
import us.abstracta.wiresham.FlowConnectionProvider;

public class VirtualTcpClient {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualTcpClient.class);
    private static final int DEFAULT_READ_BUFFER_SIZE = 2048;
    private Flow flow;
    private String host;
    private int port;
    private int readBufferSize = 2048;
    private ExecutorService executorService;
    private ConnectionFlowDriver connection;
    private SSLContext sslContext;

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public void setServerAddress(String serverAddress) {
        int portSeparatorPos = serverAddress.lastIndexOf(":");
        this.host = serverAddress.substring(0, portSeparatorPos);
        this.port = Integer.parseInt(serverAddress.substring(portSeparatorPos + 1));
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    private Socket buildSocket(int port) throws IOException {
        if (this.sslContext != null) {
            return this.sslContext.getSocketFactory().createSocket(this.host, port);
        }
        return new Socket(this.host, port);
    }

    public void run() {
        this.executorService = Executors.newSingleThreadExecutor();
        this.connection = new ConnectionFlowDriver(this.buildFlowConnectionProvider(), this.flow, this.port);
        this.executorService.submit(this.connection);
    }

    private FlowConnectionProvider buildFlowConnectionProvider() {
        return new FlowConnectionProvider(){
            public final Map<Integer, FlowConnection> map = new ConcurrentHashMap<Integer, FlowConnection>();

            @Override
            public FlowConnection get(int port) throws IOException {
                if (this.map.get(port) == null) {
                    this.map.put(port, new FlowConnection(VirtualTcpClient.this.buildSocket(port), VirtualTcpClient.this.readBufferSize));
                }
                return this.map.get(port);
            }

            @Override
            public void init(List<Integer> ports, FlowConnection flowConnection) {
                this.map.put(flowConnection.getPort(), flowConnection);
            }

            @Override
            public void closeConnections() throws IOException {
                for (FlowConnection value : this.map.values()) {
                    value.close();
                }
            }
        };
    }

    public void stop(long timeoutMillis) throws InterruptedException, IOException {
        this.connection.closeFlowConnections();
        this.executorService.shutdown();
        this.executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
        this.executorService.shutdownNow();
        if (!this.executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
            LOG.warn("Client didn't stop after {} millis", (Object)timeoutMillis);
        }
    }
}

