/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.wiresham.ConnectionFlowDriver;
import us.abstracta.wiresham.Flow;
import us.abstracta.wiresham.FlowConnection;
import us.abstracta.wiresham.FlowConnectionProvider;
import us.abstracta.wiresham.PacketStep;
import us.abstracta.wiresham.ReceivePacketStep;

public class VirtualTcpService {
    public static final int DEFAULT_READ_BUFFER_SIZE = 2048;
    public static final int DEFAULT_MAX_CONNECTION_COUNT = 1;
    public static final int DYNAMIC_PORT = 0;
    public static final int CLOSE_SOCKETS_TIMEOUT_MILLIS = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(VirtualTcpService.class);
    private int portArgument = 0;
    private Flow flow;
    private boolean sslEnabled;
    private SSLContext sslContext;
    private int readBufferSize = 2048;
    private int maxConnections = 1;
    private boolean stopped = false;
    private final Set<ConnectionFlowDriver> connectionDrivers = new HashSet<ConnectionFlowDriver>();
    private ExecutorService clientExecutorService;
    private ExecutorService portExecutorService;

    public void setPortArgument(int portArgument) {
        this.portArgument = portArgument;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
        Optional<PacketStep> bigPacketStep = flow.getSteps().stream().filter(s -> s instanceof ReceivePacketStep && s.data.getBytes().length > this.readBufferSize).findAny();
        if (bigPacketStep.isPresent()) {
            throw new IllegalArgumentException(String.format("Read buffer size of %d bytes is not enough for receiving expected packet from client with %s", this.readBufferSize, bigPacketStep.get().data));
        }
    }

    @Deprecated
    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void start() throws IOException {
        this.stopped = false;
        int portCount = this.flow.getPortCount();
        this.portExecutorService = Executors.newFixedThreadPool(portCount == 0 ? 1 : portCount);
        this.clientExecutorService = Executors.newFixedThreadPool(this.maxConnections);
        this.startServerPorts();
    }

    public void startServerPorts() throws IOException {
        for (Integer port : this.getPorts()) {
            ServerSocket serverSocket = this.buildSocket(port);
            LOG.info("Waiting for connections on {}", (Object)port);
            this.portExecutorService.execute(() -> {
                while (!this.stopped) {
                    try {
                        this.assignFlowConnectionToConnectionDriver(port, new FlowConnection(serverSocket.accept(), this.readBufferSize));
                    }
                    catch (IOException e) {
                        this.handleSocketIOException(e);
                    }
                }
            });
        }
    }

    private List<Integer> getPorts() {
        return this.flow.getPorts().isEmpty() ? Collections.singletonList(this.portArgument) : this.flow.getPorts();
    }

    private ServerSocket buildSocket(int port) throws IOException {
        if (this.sslContext != null) {
            return this.sslContext.getServerSocketFactory().createServerSocket(port);
        }
        return new ServerSocket(port);
    }

    private synchronized void assignFlowConnectionToConnectionDriver(Integer port, FlowConnection flowConnection) {
        Optional<FlowConnectionProvider> first = this.connectionDrivers.stream().map(ConnectionFlowDriver::getConnectionProvider).filter(f -> f.requiresFlowConnection(port)).findFirst();
        if (first.isPresent()) {
            first.get().assignFlowConnection(port, flowConnection);
            return;
        }
        FlowConnectionProvider connectionProvider = this.buildFlowConnectionProvider();
        connectionProvider.init(this.flow.getPorts(), flowConnection);
        this.addClient(new ConnectionFlowDriver(connectionProvider, this.flow, this.portArgument));
    }

    private synchronized void addClient(ConnectionFlowDriver connectionDriver) {
        if (this.stopped) {
            try {
                connectionDriver.closeFlowConnections();
            }
            catch (IOException e) {
                LOG.error("Error occurred while closing socket connections");
            }
            return;
        }
        this.connectionDrivers.add(connectionDriver);
        this.clientExecutorService.submit(() -> {
            connectionDriver.run();
            this.removeClient(connectionDriver);
        });
    }

    private synchronized void removeClient(ConnectionFlowDriver connectionDriver) {
        this.connectionDrivers.remove(connectionDriver);
    }

    private void handleSocketIOException(IOException e) {
        if (this.stopped) {
            LOG.trace("Received expected exception when server socket has been closed", (Throwable)e);
        } else {
            LOG.error("Problem waiting for client connection. Keep waiting.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long timeoutMillis) throws InterruptedException {
        VirtualTcpService virtualTcpService = this;
        synchronized (virtualTcpService) {
            this.stopped = true;
            this.connectionDrivers.forEach(c -> {
                try {
                    c.closeFlowConnections();
                }
                catch (IOException e) {
                    LOG.error("Problem closing connection ", (Throwable)e);
                }
            });
        }
        this.clientExecutorService.shutdown();
        if (!this.clientExecutorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
            this.clientExecutorService.shutdownNow();
        }
    }

    private FlowConnectionProvider buildFlowConnectionProvider() {
        return new FlowConnectionProvider(){
            public final Map<Integer, CompletableFuture<FlowConnection>> map = new ConcurrentHashMap<Integer, CompletableFuture<FlowConnection>>();

            @Override
            public FlowConnection get(int port) throws ExecutionException, InterruptedException {
                return this.map.get(port).get();
            }

            @Override
            public void init(List<Integer> ports, FlowConnection flowConnection) {
                this.map.clear();
                for (Integer port : ports) {
                    this.map.put(port, new CompletableFuture());
                }
                CompletableFuture<FlowConnection> completedFuture = new CompletableFuture<FlowConnection>();
                completedFuture.complete(flowConnection);
                this.map.put(flowConnection.getPort(), completedFuture);
            }

            @Override
            public void assignFlowConnection(int port, FlowConnection flowConnection) {
                this.map.get(port).complete(flowConnection);
            }

            @Override
            public boolean requiresFlowConnection(int port) {
                return !this.map.get(port).isDone();
            }

            @Override
            public void closeConnections() throws IOException {
                for (CompletableFuture<FlowConnection> value : this.map.values()) {
                    try {
                        value.cancel(false);
                        value.get(10000L, TimeUnit.MILLISECONDS).close();
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                    catch (CancellationException e) {
                        LOG.error("Connection canceled since service stopped", (Throwable)e);
                    }
                }
                this.map.clear();
            }
        };
    }
}

