/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.wiresham;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.LoggerFactory;
import us.abstracta.wiresham.Flow;
import us.abstracta.wiresham.ReloadService;
import us.abstracta.wiresham.VirtualTcpClient;
import us.abstracta.wiresham.VirtualTcpService;

public class VirtualTcpServiceMain {
    public static final long STOP_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    @Option(name="-p", aliases={"--port"}, metaVar="port", usage="Port to receive connections to the virtual service")
    private int port;
    @Option(name="-t", aliases={"--target-server-address"}, metaVar="targetAddress", usage="Address where to send packets when acting as virtual client")
    private String targetAddress;
    @Option(name="-b", aliases={"--read-buffer-size-bytes"}, metaVar="bytes count", usage="Size (in bytes) of buffer used to receive packets from client. Default value: 2048")
    private int readBufferSize = 2048;
    @Option(name="-c", aliases={"--max-concurrent-connections"}, metaVar="connection count", usage="Maximum number of concurrent client connections to attend. Default value: 1")
    private int maxConnectionCount = 1;
    @Option(name="-s", aliases={"--ssl-enabled"}, usage="Specifies if the server should start with SSL protocol support. When this option is specified. Use standard JSSE properties like javax.net.ssl.keyStore and javax.net.ssl.keyStorePassword to tune the configuration.")
    private boolean sslEnabled;
    @Option(name="-a", aliases={"--server-address"}, metaVar="ip:port", usage="When using a Wireshark generated JSON dump or PCAP file, this parameter specifies the IP address (and optionally the port, when server and port are in same ip) which identifies the service to be virtualized")
    private String serverAddress;
    @Option(name="-f", aliases={"--pcap-filter-expression"}, metaVar="expression", usage="Expression used to filter packets from a PCAP file. Eg: 'port 23'")
    private String pcapFilter;
    @Option(name="-d", aliases={"--dump-file"}, metaVar=".yml file", usage="File path to dump loaded flow config. The virtual service will not be started when this option is specified. This option makes sense when a Wireshark JSON file is used for config to dump a simplified and smaller file and then manually tune it if needed")
    private File dumpFile;
    @Option(name="-v", aliases={"--verbose"}, usage="Logs debug messages")
    private boolean verbose;
    @Option(name="-vv", aliases={"--super-verbose"}, usage="Logs trace messages")
    private boolean superVerbose;
    @Option(name="-h", aliases={"--help"}, usage="Show usage information", help=true)
    private boolean displayHelp;
    @Option(name="-r", aliases={"--auto-reload"}, usage="When enabled, will listen for changes in dump file, when the file has changes all new connections from now on, will use the new version of the dump. Established connections will persist using previous dump and won't suffer any interruption. Default: enabled")
    private boolean autoReload;
    @Argument(metaVar="config file", required=true, usage="Configuration file from where to read packets information")
    private File configFile;
    private final Supplier<Flow> loadFlowProvider = () -> {
        try {
            if (this.serverAddress != null) {
                if (this.configFile.getName().toLowerCase().endsWith(".json")) {
                    return Flow.fromWiresharkJsonDump(this.configFile, this.serverAddress);
                }
                return Flow.fromPcap(this.configFile, this.serverAddress, this.pcapFilter);
            }
            return Flow.fromYml(this.configFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
    };

    public static void main(String[] args) throws IOException, InterruptedException {
        VirtualTcpServiceMain main = new VirtualTcpServiceMain();
        CmdLineParser parser = new CmdLineParser((Object)main);
        try {
            parser.parseArgument(args);
            if (main.isDisplayHelp()) {
                VirtualTcpServiceMain.printHelp(parser, System.out);
            } else {
                main.run();
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            VirtualTcpServiceMain.printHelp(parser, System.err);
        }
    }

    private boolean isDisplayHelp() {
        return this.displayHelp;
    }

    private static void printHelp(CmdLineParser parser, PrintStream printStream) {
        String command = "java -jar wiresham-standalone.jar";
        printStream.println(command + " [options...] <config file>");
        parser.printUsage((OutputStream)printStream);
        printStream.println();
        printStream.println("  Examples: \n" + command + " -p 2324 login-invalid-creds.yml\n" + command + " -p 2324 -a 0.0.0.0 login-invalid-creds-wireshark.json\n" + command + " -p 2324 -a 0.0.0.0 login-invalid-creds.pcap\n" + command + " -p 2324 -a 0.0.0.0 -f \"port 23\" login-invalid-creds.pcap\n" + command + " -d login-invalid-creds.yml -a 0.0.0.0 login-invalid-creds-wireshark.json\n" + command + " -t 127.0.0.1:2324 login-invalid-creds.yml");
    }

    private void run() throws IOException, InterruptedException {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(this.superVerbose ? Level.TRACE : (this.verbose ? Level.DEBUG : Level.INFO));
        Flow flow = this.loadFlowProvider.get();
        if (this.dumpFile != null) {
            flow.saveYml(this.dumpFile);
        } else if (this.targetAddress != null) {
            this.runVirtualClient(flow.reversed());
        } else {
            this.runVirtualService(flow);
        }
    }

    private void runVirtualClient(Flow flow) {
        VirtualTcpClient client = new VirtualTcpClient();
        client.setServerAddress(this.targetAddress);
        client.setReadBufferSize(this.readBufferSize);
        if (this.sslEnabled) {
            try {
                client.setSslContext(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        client.setFlow(flow);
        client.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runVirtualService(Flow flow) throws IOException, InterruptedException {
        VirtualTcpService service = new VirtualTcpService();
        service.setPortArgument(this.port);
        if (this.sslEnabled) {
            try {
                service.setSslContext(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        service.setReadBufferSize(this.readBufferSize);
        service.setMaxConnections(this.maxConnectionCount);
        service.setFlow(flow);
        ReloadService reloadService = null;
        if (!this.autoReload) {
            reloadService = new ReloadService(service, this.configFile, this.loadFlowProvider);
            reloadService.start();
        }
        service.start();
        try {
            while (true) {
                VirtualTcpServiceMain virtualTcpServiceMain = this;
                synchronized (virtualTcpServiceMain) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            service.stop(STOP_TIMEOUT_MILLIS);
            if (reloadService != null) {
                reloadService.stop();
            }
            Thread.currentThread().interrupt();
            return;
        }
    }
}

