/*
 * Decompiled with CFR 0.152.
 */
package us.avodagroup.connectors.textract.internal.connection.provider;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.avodagroup.connectors.textract.internal.connection.TextractConnection;
import us.avodagroup.connectors.textract.internal.connection.provider.parameter.RegionValuesProvider;

public class TextractConnectionProvider
implements PoolingConnectionProvider<TextractConnection> {
    private final Logger LOGGER = LoggerFactory.getLogger(TextractConnectionProvider.class);
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Access Key")
    @Placement(order=1)
    @Summary(value="Access key provided by Amazon.")
    private String accessKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Secret Key")
    @Placement(order=2)
    @Summary(value="Secret key provided by Amazon.")
    private String secretKey;
    @OfValues(value=RegionValuesProvider.class)
    @Optional(defaultValue="us-east-1")
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Region Endpoint")
    @Placement(order=5)
    @Summary(value="Textract region endpoint.")
    private String region;

    public TextractConnection connect() throws ConnectionException {
        return new TextractConnection(this.region, this.accessKey, this.secretKey);
    }

    public void disconnect(TextractConnection connection) {
        try {
            connection.invalidate();
        }
        catch (Exception e) {
            this.LOGGER.error("Error while disconnecting []: " + e.getMessage(), (Throwable)e);
        }
    }

    public ConnectionValidationResult validate(TextractConnection connection) {
        return ConnectionValidationResult.success();
    }
}

