/*
 * Decompiled with CFR 0.152.
 */
package us.avodagroup.connectors.textract.internal.operation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse;
import software.amazon.awssdk.services.textract.model.Document;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.S3Object;
import us.avodagroup.connectors.textract.internal.config.TextractConfiguration;
import us.avodagroup.connectors.textract.internal.connection.TextractConnection;

public class AnalyzeDocuments {
    private static final I18nMessage NOT_IMPLEMENTED = I18nMessageFactory.createStaticMessage((String)"Operation not implemented");

    @MediaType(value="application/json", strict=false)
    public String analyzeDocument(@Config TextractConfiguration configuration, @Connection TextractConnection connection, @DisplayName(value="Bucket name") String bucket, @DisplayName(value="Key") String key) {
        S3Object s3Object = (S3Object)S3Object.builder().bucket(bucket).name(key).build();
        Document document = (Document)Document.builder().s3Object(s3Object).build();
        ArrayList<FeatureType> featureTypes = new ArrayList<FeatureType>();
        featureTypes.add(FeatureType.FORMS);
        AnalyzeDocumentRequest req = (AnalyzeDocumentRequest)AnalyzeDocumentRequest.builder().document(document).featureTypes(featureTypes).build();
        AnalyzeDocumentResponse resp = connection.analyzeDocument(req);
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            return mapper.writeValueAsString((Object)resp);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @MediaType(value="*/*", strict=false)
    public String analyzeExpense(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }

    @MediaType(value="*/*", strict=false)
    public String analyzeId(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }

    @MediaType(value="*/*", strict=false)
    public String detectDocumentText(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }
}

