/*
 * Decompiled with CFR 0.152.
 */
package us.avodagroup.connectors.textract.internal.operation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import software.amazon.awssdk.services.textract.model.DocumentLocation;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.NotificationChannel;
import software.amazon.awssdk.services.textract.model.S3Object;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse;
import us.avodagroup.connectors.textract.internal.config.TextractConfiguration;
import us.avodagroup.connectors.textract.internal.connection.TextractConnection;

public class AsyncAnalyzeDocuments {
    private static final I18nMessage NOT_IMPLEMENTED = I18nMessageFactory.createStaticMessage((String)"Operation not implemented");

    @MediaType(value="application/json", strict=false)
    public String retrieveDocumentAnalysis(@Config TextractConfiguration configuration, @Connection TextractConnection connection, String jobId) {
        boolean isFinished = false;
        GetDocumentAnalysisRequest analysisRequest = (GetDocumentAnalysisRequest)GetDocumentAnalysisRequest.builder().jobId(jobId).maxResults(Integer.valueOf(1000)).build();
        GetDocumentAnalysisResponse resp = connection.getDocumentAnalysis(analysisRequest);
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            return mapper.writeValueAsString((Object)resp);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @MediaType(value="*/*", strict=false)
    public String retrieveDocumentTextDetection(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }

    @MediaType(value="*/*", strict=false)
    public String retrieveExpenseAnalysis(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }

    @MediaType(value="*/*", strict=false)
    public String retrieveLendingAnalysis(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }

    @MediaType(value="*/*", strict=false)
    public String startDocumentAnalysis(@Config TextractConfiguration configuration, @Connection TextractConnection connection, @DisplayName(value="Bucket name") String bucket, @DisplayName(value="Key") String key, @DisplayName(value="sNS ARN") String snsARN) {
        S3Object s3Object = (S3Object)S3Object.builder().bucket(bucket).name(key).build();
        DocumentLocation location = (DocumentLocation)DocumentLocation.builder().s3Object(s3Object).build();
        NotificationChannel snsChannel = (NotificationChannel)NotificationChannel.builder().snsTopicArn(snsARN).build();
        ArrayList<FeatureType> featureTypes = new ArrayList<FeatureType>();
        featureTypes.add(FeatureType.FORMS);
        StartDocumentAnalysisRequest request = (StartDocumentAnalysisRequest)StartDocumentAnalysisRequest.builder().documentLocation(location).featureTypes(featureTypes).notificationChannel(snsChannel).build();
        StartDocumentAnalysisResponse resp = connection.startDocumentAnalysis(request);
        return resp.jobId();
    }

    @MediaType(value="*/*", strict=false)
    public String startDocumentTextDetection(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }

    @MediaType(value="*/*", strict=false)
    public String startExpenseAnalysis(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }

    @MediaType(value="*/*", strict=false)
    public String startLendingAnalysis(@Config TextractConfiguration configuration, @Connection TextractConnection connection) {
        throw new MuleRuntimeException(NOT_IMPLEMENTED);
    }

    private class AsyncAnalysisResult {
        private Boolean isCompleted;

        private AsyncAnalysisResult() {
        }
    }
}

