/*
 * Decompiled with CFR 0.152.
 */
package us.bpsm.textlineiterable;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import java.util.Set;
import us.bpsm.textlineiterable.CloseableIterator;

public class TextLineIterable
extends FluentIterable<String>
implements Closeable {
    final CharSource charSource;
    final Set<LineIterator> awaitingClose;

    public TextLineIterable(CharSource charSource) {
        this.charSource = charSource;
        this.awaitingClose = Sets.newHashSet();
    }

    public TextLineIterable(File textFile, Charset charset) {
        this(Files.asCharSource((File)textFile, (Charset)charset));
    }

    public TextLineIterable(CharSequence text) {
        this(CharSource.wrap((CharSequence)text));
    }

    public synchronized CloseableIterator<String> iterator() {
        try {
            return new LineIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        IOException failure = null;
        for (LineIterator li : ImmutableSet.copyOf(this.awaitingClose)) {
            try {
                li.close();
            }
            catch (IOException e) {
                failure = e;
            }
        }
        assert (this.awaitingClose.isEmpty()) : "LineIterator.close() must de-register its receiver.";
        if (failure != null) {
            throw failure;
        }
    }

    static void closeQuietly(Closeable resource) {
        try {
            resource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class LineIterator
    implements CloseableIterator<String> {
        final BufferedReader reader;
        String peek = null;
        String msg = null;

        LineIterator() throws IOException {
            BufferedReader reader = TextLineIterable.this.charSource.openBufferedStream();
            try {
                this.peek = reader.readLine();
            }
            catch (IOException e) {
                assert (this.peek == null);
                this.msg = e.getMessage();
                TextLineIterable.closeQuietly(reader);
                throw e;
            }
            this.reader = reader;
            TextLineIterable.this.awaitingClose.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.reader.close();
            }
            finally {
                TextLineIterable textLineIterable = TextLineIterable.this;
                synchronized (textLineIterable) {
                    TextLineIterable.this.awaitingClose.remove(this);
                }
                this.peek = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.peek != null;
        }

        @Override
        public String next() {
            String result;
            block3: {
                if (this.peek == null) {
                    throw new NoSuchElementException(this.msg);
                }
                result = this.peek;
                try {
                    this.peek = this.reader.readLine();
                }
                catch (IOException e) {
                    this.msg = e.getMessage();
                    TextLineIterable.closeQuietly(this);
                    if ($assertionsDisabled || this.peek == null) break block3;
                    throw new AssertionError();
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

