/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import us.codecraft.webmagic.Task;

public class Site {
    private String domain;
    private String userAgent;
    private Map<String, String> defaultCookies = new LinkedHashMap<String, String>();
    private Map<String, Map<String, String>> cookies = new HashMap<String, Map<String, String>>();
    private String charset;
    private String defaultCharset;
    private int sleepTime = 5000;
    private int retryTimes = 0;
    private int cycleRetryTimes = 0;
    private int retrySleepTime = 1000;
    private int timeOut = 5000;
    private static final Set<Integer> DEFAULT_STATUS_CODE_SET = new HashSet<Integer>();
    private Set<Integer> acceptStatCode = DEFAULT_STATUS_CODE_SET;
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean useGzip = true;
    private boolean disableCookieManagement = false;

    public static Site me() {
        return new Site();
    }

    public Site addCookie(String name, String value) {
        this.defaultCookies.put(name, value);
        return this;
    }

    public Site addCookie(String domain, String name, String value) {
        if (!this.cookies.containsKey(domain)) {
            this.cookies.put(domain, new HashMap());
        }
        this.cookies.get(domain).put(name, value);
        return this;
    }

    public Site setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public Map<String, String> getCookies() {
        return this.defaultCookies;
    }

    public Map<String, Map<String, String>> getAllCookies() {
        return this.cookies;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getDomain() {
        return this.domain;
    }

    public Site setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Site setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public Site setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
        return this;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public Site setTimeOut(int timeOut) {
        this.timeOut = timeOut;
        return this;
    }

    public Site setAcceptStatCode(Set<Integer> acceptStatCode) {
        this.acceptStatCode = acceptStatCode;
        return this;
    }

    public Set<Integer> getAcceptStatCode() {
        return this.acceptStatCode;
    }

    public Site setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
        return this;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Site addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Site setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    public int getCycleRetryTimes() {
        return this.cycleRetryTimes;
    }

    public Site setCycleRetryTimes(int cycleRetryTimes) {
        this.cycleRetryTimes = cycleRetryTimes;
        return this;
    }

    public boolean isUseGzip() {
        return this.useGzip;
    }

    public int getRetrySleepTime() {
        return this.retrySleepTime;
    }

    public Site setRetrySleepTime(int retrySleepTime) {
        this.retrySleepTime = retrySleepTime;
        return this;
    }

    public Site setUseGzip(boolean useGzip) {
        this.useGzip = useGzip;
        return this;
    }

    public boolean isDisableCookieManagement() {
        return this.disableCookieManagement;
    }

    public Site setDisableCookieManagement(boolean disableCookieManagement) {
        this.disableCookieManagement = disableCookieManagement;
        return this;
    }

    public Task toTask() {
        return new Task(){

            @Override
            public String getUUID() {
                String uuid = Site.this.getDomain();
                if (uuid == null) {
                    uuid = UUID.randomUUID().toString();
                }
                return uuid;
            }

            @Override
            public Site getSite() {
                return Site.this;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Site site = (Site)o;
        if (this.cycleRetryTimes != site.cycleRetryTimes) {
            return false;
        }
        if (this.retryTimes != site.retryTimes) {
            return false;
        }
        if (this.sleepTime != site.sleepTime) {
            return false;
        }
        if (this.timeOut != site.timeOut) {
            return false;
        }
        if (this.acceptStatCode != null ? !this.acceptStatCode.equals(site.acceptStatCode) : site.acceptStatCode != null) {
            return false;
        }
        if (this.charset != null ? !this.charset.equals(site.charset) : site.charset != null) {
            return false;
        }
        if (this.defaultCookies != null ? !this.defaultCookies.equals(site.defaultCookies) : site.defaultCookies != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(site.domain) : site.domain != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(site.headers) : site.headers != null) {
            return false;
        }
        return !(this.userAgent != null ? !this.userAgent.equals(site.userAgent) : site.userAgent != null);
    }

    public int hashCode() {
        int result = this.domain != null ? this.domain.hashCode() : 0;
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        result = 31 * result + (this.defaultCookies != null ? this.defaultCookies.hashCode() : 0);
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        result = 31 * result + this.sleepTime;
        result = 31 * result + this.retryTimes;
        result = 31 * result + this.cycleRetryTimes;
        result = 31 * result + this.timeOut;
        result = 31 * result + (this.acceptStatCode != null ? this.acceptStatCode.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Site{domain='" + this.domain + '\'' + ", userAgent='" + this.userAgent + '\'' + ", cookies=" + this.defaultCookies + ", charset='" + this.charset + '\'' + ", sleepTime=" + this.sleepTime + ", retryTimes=" + this.retryTimes + ", cycleRetryTimes=" + this.cycleRetryTimes + ", timeOut=" + this.timeOut + ", acceptStatCode=" + this.acceptStatCode + ", headers=" + this.headers + '}';
    }

    static {
        DEFAULT_STATUS_CODE_SET.add(200);
    }
}

