/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.downloader.HttpClientPool;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.utils.UrlUtils;

@ThreadSafe
public class HttpClientDownloader
implements Downloader {
    private Logger logger = Logger.getLogger(this.getClass());
    private int poolSize = 1;

    public Html download(String url) {
        Page page = this.download(new Request(url), null);
        return (Html)page.getHtml();
    }

    @Override
    public Page download(Request request, Task task) {
        Set<Object> acceptStatCode;
        Site site = null;
        if (task != null) {
            site = task.getSite();
        }
        int retryTimes = 0;
        String charset = null;
        if (site != null) {
            retryTimes = site.getRetryTimes();
            acceptStatCode = site.getAcceptStatCode();
            charset = site.getCharset();
        } else {
            acceptStatCode = new HashSet<Integer>();
            acceptStatCode.add(200);
        }
        this.logger.info((Object)("downloading page " + request.getUrl()));
        HttpClient httpClient = HttpClientPool.getInstance(this.poolSize).getClient(site);
        try {
            boolean retry;
            HttpGet httpGet = new HttpGet(request.getUrl());
            HttpResponse httpResponse = null;
            int tried = 0;
            do {
                try {
                    httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                    retry = false;
                }
                catch (IOException e) {
                    if (++tried > retryTimes) {
                        this.logger.warn((Object)("download page " + request.getUrl() + " error"), (Throwable)e);
                        return null;
                    }
                    this.logger.info((Object)("download page " + request.getUrl() + " error, retry the " + tried + " time!"));
                    retry = true;
                }
            } while (retry);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (acceptStatCode.contains(statusCode)) {
                if (charset == null) {
                    String value = httpResponse.getEntity().getContentType().getValue();
                    charset = UrlUtils.getCharset(value);
                }
                this.handleGzip(httpResponse);
                return this.handleResponse(request, charset, httpResponse, task);
            }
            this.logger.warn((Object)("code error " + statusCode + "\t" + request.getUrl()));
        }
        catch (Exception e) {
            this.logger.warn((Object)("download page " + request.getUrl() + " error"), (Throwable)e);
        }
        return null;
    }

    protected Page handleResponse(Request request, String charset, HttpResponse httpResponse, Task task) throws IOException {
        String content = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)charset);
        Page page = new Page();
        page.setHtml(new Html(UrlUtils.fixAllRelativeHrefs(content, request.getUrl())));
        page.setUrl(new PlainText(request.getUrl()));
        page.setRequest(request);
        return page;
    }

    @Override
    public void setThread(int thread) {
        this.poolSize = thread;
    }

    private void handleGzip(HttpResponse httpResponse) {
        Header ceheader = httpResponse.getEntity().getContentEncoding();
        if (ceheader != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                httpResponse.setEntity((HttpEntity)new GzipDecompressingEntity(httpResponse.getEntity()));
            }
        }
    }
}

