/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.utils.UrlUtils;

public class Site {
    private String domain;
    private String userAgent;
    private Map<String, String> cookies = new LinkedHashMap<String, String>();
    private String charset;
    private List<String> startUrls = new ArrayList<String>();
    private int sleepTime = 3000;
    private int retryTimes = 0;
    private int cycleRetryTimes = 0;
    private static final Set<Integer> DEFAULT_STATUS_CODE_SET = new HashSet<Integer>();
    private Set<Integer> acceptStatCode = DEFAULT_STATUS_CODE_SET;

    public static Site me() {
        return new Site();
    }

    public Site addCookie(String name, String value) {
        this.cookies.put(name, value);
        return this;
    }

    public Site setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getDomain() {
        return this.domain;
    }

    public Site setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Site setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public Site setAcceptStatCode(Set<Integer> acceptStatCode) {
        this.acceptStatCode = acceptStatCode;
        return this;
    }

    public Set<Integer> getAcceptStatCode() {
        return this.acceptStatCode;
    }

    public List<String> getStartUrls() {
        return this.startUrls;
    }

    public Site addStartUrl(String startUrl) {
        this.startUrls.add(startUrl);
        if (this.domain == null && this.startUrls.size() > 0) {
            this.domain = UrlUtils.getDomain(this.startUrls.get(0));
        }
        return this;
    }

    public Site setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
        return this;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public Site setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    public int getCycleRetryTimes() {
        return this.cycleRetryTimes;
    }

    public Site setCycleRetryTimes(int cycleRetryTimes) {
        this.cycleRetryTimes = cycleRetryTimes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Site site = (Site)o;
        if (this.acceptStatCode != null ? !this.acceptStatCode.equals(site.acceptStatCode) : site.acceptStatCode != null) {
            return false;
        }
        if (!this.domain.equals(site.domain)) {
            return false;
        }
        if (!this.startUrls.equals(site.startUrls)) {
            return false;
        }
        if (this.charset != null ? !this.charset.equals(site.charset) : site.charset != null) {
            return false;
        }
        return !(this.userAgent != null ? !this.userAgent.equals(site.userAgent) : site.userAgent != null);
    }

    public Task toTask() {
        return new Task(){

            @Override
            public String getUUID() {
                return Site.this.getDomain();
            }

            @Override
            public Site getSite() {
                return Site.this;
            }
        };
    }

    public int hashCode() {
        int result = this.domain.hashCode();
        result = 31 * result + (this.startUrls != null ? this.startUrls.hashCode() : 0);
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        result = 31 * result + (this.acceptStatCode != null ? this.acceptStatCode.hashCode() : 0);
        return result;
    }

    static {
        DEFAULT_STATUS_CODE_SET.add(200);
    }
}

