/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.utils.UrlUtils;

public class Page {
    private Request request;
    private ResultItems resultItems = new ResultItems();
    private Html html;
    private Selectable url;
    private List<Request> targetRequests = new ArrayList<Request>();

    public Page setSkip(boolean skip) {
        this.resultItems.setSkip(skip);
        return this;
    }

    public void putField(String key, Object field) {
        this.resultItems.put(key, field);
    }

    public Html getHtml() {
        return this.html;
    }

    public void setHtml(Html html) {
        this.html = html;
    }

    public List<Request> getTargetRequests() {
        return this.targetRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetRequests(List<String> requests) {
        List<Request> list = this.targetRequests;
        synchronized (list) {
            for (String s : requests) {
                if (StringUtils.isBlank((CharSequence)s) || s.equals("#") || s.startsWith("javascript:")) break;
                s = UrlUtils.canonicalizeUrl(s, ((Object)this.url).toString());
                this.targetRequests.add(new Request(s));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetRequests(List<String> requests, long priority) {
        List<Request> list = this.targetRequests;
        synchronized (list) {
            for (String s : requests) {
                if (StringUtils.isBlank((CharSequence)s) || s.equals("#") || s.startsWith("javascript:")) break;
                s = UrlUtils.canonicalizeUrl(s, ((Object)this.url).toString());
                this.targetRequests.add(new Request(s).setPriority(priority));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetRequest(String requestString) {
        if (StringUtils.isBlank((CharSequence)requestString) || requestString.equals("#")) {
            return;
        }
        List<Request> list = this.targetRequests;
        synchronized (list) {
            requestString = UrlUtils.canonicalizeUrl(requestString, ((Object)this.url).toString());
            this.targetRequests.add(new Request(requestString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetRequest(Request request) {
        List<Request> list = this.targetRequests;
        synchronized (list) {
            this.targetRequests.add(request);
        }
    }

    public Selectable getUrl() {
        return this.url;
    }

    public void setUrl(Selectable url) {
        this.url = url;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
        this.resultItems.setRequest(request);
    }

    public ResultItems getResultItems() {
        return this.resultItems;
    }

    public String toString() {
        return "Page{request=" + this.request + ", resultItems=" + this.resultItems + ", html=" + this.html + ", url=" + this.url + ", targetRequests=" + this.targetRequests + '}';
    }
}

