/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import us.codecraft.webmagic.model.HttpRequestBody;
import us.codecraft.webmagic.utils.Experimental;

public class Request
implements Serializable {
    private static final long serialVersionUID = 2062192774891352043L;
    public static final String CYCLE_TRIED_TIMES = "_cycle_tried_times";
    private String url;
    private String method;
    private HttpRequestBody requestBody;
    private Map<String, Object> extras;
    private Map<String, String> cookies = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private long priority;

    public Request() {
    }

    public Request(String url) {
        this.url = url;
    }

    public long getPriority() {
        return this.priority;
    }

    @Experimental
    public Request setPriority(long priority) {
        this.priority = priority;
        return this;
    }

    public Object getExtra(String key) {
        if (this.extras == null) {
            return null;
        }
        return this.extras.get(key);
    }

    public Request putExtra(String key, Object value) {
        if (this.extras == null) {
            this.extras = new HashMap<String, Object>();
        }
        this.extras.put(key, value);
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public void setExtras(Map<String, Object> extras) {
        this.extras = extras;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        if (this.url != null ? !this.url.equals(request.url) : request.url != null) {
            return false;
        }
        return this.method != null ? this.method.equals(request.method) : request.method == null;
    }

    public Request addCookie(String name, String value) {
        this.cookies.put(name, value);
        return this;
    }

    public Request addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpRequestBody getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(HttpRequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public String toString() {
        return "Request{url='" + this.url + '\'' + ", method='" + this.method + '\'' + ", extras=" + this.extras + ", priority=" + this.priority + ", headers=" + this.headers + ", cookies=" + this.cookies + '}';
    }
}

