/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.proxy.Proxy;
import us.codecraft.webmagic.proxy.ProxyProvider;

public class SimpleProxyProvider
implements ProxyProvider {
    private final List<Proxy> proxies;
    private final AtomicInteger pointer;

    private SimpleProxyProvider(List<Proxy> proxies, AtomicInteger pointer) {
        this.proxies = proxies;
        this.pointer = pointer;
    }

    public static SimpleProxyProvider from(Proxy ... proxies) {
        ArrayList<Proxy> proxiesTemp = new ArrayList<Proxy>(proxies.length);
        for (Proxy proxy : proxies) {
            proxiesTemp.add(proxy);
        }
        return new SimpleProxyProvider(Collections.unmodifiableList(proxiesTemp), new AtomicInteger(-1));
    }

    @Override
    public void returnProxy(Proxy proxy, Page page, Task task) {
    }

    @Override
    public Proxy getProxy(Task task) {
        return this.proxies.get(this.incrForLoop());
    }

    private int incrForLoop() {
        int size;
        int p = this.pointer.incrementAndGet();
        if (p < (size = this.proxies.size())) {
            return p;
        }
        while (!this.pointer.compareAndSet(p, p % size)) {
            p = this.pointer.get();
        }
        return p % size;
    }
}

