/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.scheduler.Scheduler;
import us.codecraft.webmagic.thread.CountableThreadPool;

public class SpiderScheduler {
    private Scheduler scheduler;
    private final ReentrantLock newUrlLock = new ReentrantLock();
    private final Condition newUrlCondition = this.newUrlLock.newCondition();

    public SpiderScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Request poll(Spider spider) {
        return this.scheduler.poll(spider);
    }

    public void push(Request request, Spider spider) {
        this.scheduler.push(request, spider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitNewUrl(CountableThreadPool threadPool, long emptySleepTime) {
        this.newUrlLock.lock();
        try {
            if (threadPool.getThreadAlive() == 0) {
                boolean bl = false;
                return bl;
            }
            this.newUrlCondition.await(emptySleepTime, TimeUnit.MILLISECONDS);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.newUrlLock.unlock();
        }
    }

    public void signalNewUrl() {
        try {
            this.newUrlLock.lock();
            this.newUrlCondition.signalAll();
        }
        finally {
            this.newUrlLock.unlock();
        }
    }
}

