/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scripts;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.jruby.RubyHash;
import org.python.core.PyDictionary;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.scripts.Language;
import us.codecraft.webmagic.scripts.ScriptEnginePool;

public class ScriptProcessor
implements PageProcessor {
    private ScriptEnginePool enginePool;
    private String defines;
    private String script;
    private final Language language;
    private Site site = Site.me();

    public ScriptProcessor(Language language, String script, int threadNum) {
        if (language == null || script == null) {
            throw new IllegalArgumentException("language and script must not be null!");
        }
        this.language = language;
        this.enginePool = new ScriptEnginePool(language, threadNum);
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(language.getDefineFile());
        try {
            this.defines = IOUtils.toString((InputStream)resourceAsStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.script = script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Page page) {
        ScriptEngine engine = this.enginePool.getEngine();
        try {
            ScriptContext context = engine.getContext();
            context.setAttribute("page", page, 100);
            context.setAttribute("config", this.site, 100);
            try {
                switch (this.language) {
                    case JavaScript: {
                        engine.eval(this.defines + "\n" + this.script, context);
                        break;
                    }
                    case JRuby: {
                        RubyHash oRuby = (RubyHash)engine.eval(this.defines + "\n" + this.script, context);
                        for (Map.Entry pairs : oRuby.entrySet()) {
                            page.getResultItems().put(pairs.getKey().toString(), pairs.getValue());
                        }
                        break;
                    }
                    case Jython: {
                        engine.eval(this.defines + "\n" + this.script, context);
                        PyDictionary oJython = (PyDictionary)engine.get("result");
                        for (Map.Entry pairs : oJython.entrySet()) {
                            page.getResultItems().put(pairs.getKey().toString(), pairs.getValue());
                        }
                        break;
                    }
                }
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.enginePool.release(engine);
        }
    }

    public Site getSite() {
        return this.site;
    }
}

