/*
 *
 * Magnetic Track Parser
 * https://github.com/sualeh/magnetictrackparser
 * Copyright (c) 2014, Sualeh Fatehi.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package us.fatehi.magnetictrack.bankcard;


import static org.apache.commons.lang3.StringUtils.isBlank;

import java.util.regex.Matcher;

import us.fatehi.magnetictrack.BaseTrackData;

/**
 * @see <a
 *      href="https://en.wikipedia.org/wiki/ISO/IEC_7813#Magnetic_tracks">Wikipedia
 *      - ISO/IEC 7813</a>
 */
public abstract class BaseBankCardTrackData
  extends BaseTrackData
{

  private static final long serialVersionUID = 7821463290736676016L;

  protected static String getGroup(final Matcher matcher, final int group)
  {
    final int groupCount = matcher.groupCount();
    if (groupCount > group - 1)
    {
      return matcher.group(group);
    }
    else
    {
      return null;
    }
  }

  private final String discretionaryData;

  protected BaseBankCardTrackData(final String rawTrackData,
                                  final String discretionaryData)
  {
    super(rawTrackData);
    this.discretionaryData = discretionaryData;
  }

  /**
   * Gets discretionary data on the track.
   * 
   * @return Discretionary data.
   */
  public String getDiscretionaryData()
  {
    return discretionaryData;
  }

  /**
   * Whether discretionary data is present.
   *
   * @return True if discretionary data is available
   */
  public boolean hasDiscretionaryData()
  {
    return !isBlank(discretionaryData);
  }

}
