/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import us.fatehi.magnetictrack.Version;
import us.fatehi.magnetictrack.bankcard.BankCard;
import us.fatehi.magnetictrack.bankcard.BankCardMagneticTrack;
import us.fatehi.magnetictrack.bankcard.PrimaryAccountNumber;

public class Main {
    public static void main(String[] args) throws Exception {
        Version.main(new String[0]);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.println("1. Parse magnetic track data");
            System.out.println("2. Get bank card information from card number");
            System.out.println("0. Quit");
            System.out.print("Choice: ");
            int choice = NumberUtils.toInt((String)in.readLine(), (int)0);
            switch (choice) {
                case 0: {
                    System.exit(0);
                    break;
                }
                case 1: {
                    Main.parseMagneticTrackData(in);
                    break;
                }
                case 2: {
                    Main.getBankCardInformation(in);
                    break;
                }
            }
        }
    }

    private static void getBankCardInformation(BufferedReader in) throws IOException {
        while (true) {
            System.out.println("(Type 0 to return to main menu)");
            System.out.print("Bank Card Number: ");
            String line = in.readLine();
            int choice = NumberUtils.toInt((String)line, (int)-1);
            if (choice == 0) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)line)) continue;
            PrimaryAccountNumber pan = new PrimaryAccountNumber(line);
            BankCard card = new BankCard(pan);
            System.out.println(card);
        }
    }

    private static void parseMagneticTrackData(BufferedReader in) throws IOException {
        while (true) {
            System.out.println("(Type 0 to return to main menu)");
            System.out.println("Magnetic Track (followed by a blank line): ");
            StringBuilder buffer = new StringBuilder();
            while (true) {
                String line;
                int choice;
                if ((choice = NumberUtils.toInt((String)(line = in.readLine()), (int)-1)) == 0) {
                    return;
                }
                if (StringUtils.isBlank((CharSequence)line)) break;
                buffer.append(line);
            }
            BankCardMagneticTrack track = BankCardMagneticTrack.from(buffer.toString());
            System.out.println(track);
        }
    }
}

