/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import java.io.Serializable;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;
import us.fatehi.magnetictrack.bankcard.ExpirationDate;
import us.fatehi.magnetictrack.bankcard.Name;
import us.fatehi.magnetictrack.bankcard.PrimaryAccountNumber;
import us.fatehi.magnetictrack.bankcard.ServiceCode;

public class BankCard
implements Serializable {
    private static final long serialVersionUID = 6253084852668206154L;
    protected static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)"MMMM yyyy");
    private final PrimaryAccountNumber pan;
    private final Name name;
    private final ExpirationDate expirationDate;
    private final ServiceCode serviceCode;

    public BankCard() {
        this(null);
    }

    public BankCard(PrimaryAccountNumber pan) {
        this(pan, null);
    }

    public BankCard(PrimaryAccountNumber pan, ExpirationDate expirationDate) {
        this(pan, expirationDate, null);
    }

    public BankCard(PrimaryAccountNumber pan, ExpirationDate expirationDate, Name name) {
        this(pan, expirationDate, name, null);
    }

    public BankCard(PrimaryAccountNumber pan, ExpirationDate expirationDate, Name name, ServiceCode serviceCode) {
        this.pan = pan != null ? pan : new PrimaryAccountNumber();
        this.name = name != null ? name : new Name();
        this.expirationDate = expirationDate != null ? expirationDate : new ExpirationDate();
        this.serviceCode = serviceCode != null ? serviceCode : new ServiceCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BankCard)) {
            return false;
        }
        BankCard other = (BankCard)obj;
        if (this.expirationDate == null ? other.expirationDate != null : !this.expirationDate.equals(other.expirationDate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pan == null ? other.pan != null : !this.pan.equals(other.pan)) {
            return false;
        }
        return !(this.serviceCode == null ? other.serviceCode != null : !this.serviceCode.equals(other.serviceCode));
    }

    public ExpirationDate getExpirationDate() {
        return this.expirationDate;
    }

    public Name getName() {
        return this.name;
    }

    public PrimaryAccountNumber getPrimaryAccountNumber() {
        return this.pan;
    }

    public ServiceCode getServiceCode() {
        return this.serviceCode;
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && this.expirationDate.hasExpirationDate();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pan == null ? 0 : this.pan.hashCode());
        result = 31 * result + (this.serviceCode == null ? 0 : this.serviceCode.hashCode());
        return result;
    }

    public boolean hasName() {
        return this.name != null && this.name.hasName();
    }

    public boolean hasPrimaryAccountNumber() {
        return this.pan != null && this.pan.hasPrimaryAccountNumber();
    }

    public boolean hasServiceCode() {
        return this.serviceCode != null && this.serviceCode.hasServiceCode();
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        buffer.append("Bank Card Information: ").append(NEWLINE);
        if (this.hasPrimaryAccountNumber()) {
            buffer.append("  Primary Account Number: ");
            buffer.append(this.pan).append(NEWLINE);
            buffer.append("    MII: ");
            buffer.append((Object)this.pan.getMajorIndustryIdentifier()).append(NEWLINE);
            buffer.append("    IIN: ");
            buffer.append(this.pan.getIssuerIdentificationNumber()).append(NEWLINE);
            buffer.append("    Card Brand: ");
            buffer.append((Object)this.pan.getCardBrand()).append(NEWLINE);
            buffer.append("    Passes Luhn Check: ");
            buffer.append(this.pan.isPassesLuhnCheck()).append(NEWLINE);
        }
        if (this.hasExpirationDate()) {
            buffer.append("  Expiration Date: ");
            buffer.append(formatter.format((TemporalAccessor)this.expirationDate.getExpirationDate())).append(NEWLINE);
        }
        if (this.hasName()) {
            buffer.append("  Name: ");
            buffer.append(this.getName()).append(NEWLINE);
        }
        if (this.hasServiceCode()) {
            ServiceCode serviceCode = this.getServiceCode();
            buffer.append("  Service Code: ");
            buffer.append(NEWLINE);
            buffer.append("    ");
            buffer.append(serviceCode.getServiceCode1()).append(NEWLINE);
            buffer.append("    ");
            buffer.append(serviceCode.getServiceCode2()).append(NEWLINE);
            buffer.append("    ");
            buffer.append(serviceCode.getServiceCode3()).append(NEWLINE);
        }
        return buffer.toString();
    }
}

