/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;
import us.fatehi.magnetictrack.bankcard.BankCard;
import us.fatehi.magnetictrack.bankcard.BaseBankCardTrackData;
import us.fatehi.magnetictrack.bankcard.ExpirationDate;
import us.fatehi.magnetictrack.bankcard.Name;
import us.fatehi.magnetictrack.bankcard.PrimaryAccountNumber;
import us.fatehi.magnetictrack.bankcard.ServiceCode;
import us.fatehi.magnetictrack.bankcard.Track1FormatB;
import us.fatehi.magnetictrack.bankcard.Track2;
import us.fatehi.magnetictrack.bankcard.Track3;

public class BankCardMagneticTrack
extends BaseBankCardTrackData {
    private static final long serialVersionUID = -8703108091852410189L;
    protected static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)"MMMM yyyy");
    private final Track1FormatB track1;
    private final Track2 track2;
    private final Track3 track3;

    public static BankCardMagneticTrack from(String rawTrackData) {
        return new BankCardMagneticTrack(rawTrackData);
    }

    private BankCardMagneticTrack(String rawTrackData) {
        super(rawTrackData, "");
        this.track1 = Track1FormatB.from(rawTrackData);
        this.track2 = Track2.from(rawTrackData);
        this.track3 = Track3.from(rawTrackData);
    }

    @Override
    public boolean exceedsMaximumLength() {
        return this.track1.exceedsMaximumLength() || this.track2.exceedsMaximumLength() || this.track2.exceedsMaximumLength();
    }

    public Track1FormatB getTrack1() {
        return this.track1;
    }

    public Track2 getTrack2() {
        return this.track2;
    }

    public Track3 getTrack3() {
        return this.track3;
    }

    public BankCard toBankCard() {
        PrimaryAccountNumber pan = this.track1.hasPrimaryAccountNumber() ? this.track1.getPrimaryAccountNumber() : (this.track2.hasPrimaryAccountNumber() ? this.track2.getPrimaryAccountNumber() : new PrimaryAccountNumber());
        if (this.track1.hasPrimaryAccountNumber() && this.track2.hasPrimaryAccountNumber() && !this.track1.getPrimaryAccountNumber().equals(this.track2.getPrimaryAccountNumber())) {
            throw new IllegalStateException("Inconsistent primary account number between track 1 and track 2");
        }
        Name name = this.track1.hasName() ? this.track1.getName() : new Name();
        ExpirationDate expirationDate = this.track1.hasExpirationDate() ? this.track1.getExpirationDate() : (this.track2.hasExpirationDate() ? this.track2.getExpirationDate() : new ExpirationDate());
        if (this.track1.hasExpirationDate() && this.track2.hasExpirationDate() && !this.track1.getExpirationDate().equals(this.track2.getExpirationDate())) {
            throw new IllegalStateException("Inconsistent expiration date between track 1 and track 2");
        }
        ServiceCode serviceCode = this.track1.hasServiceCode() ? this.track1.getServiceCode() : (this.track2.hasServiceCode() ? this.track2.getServiceCode() : new ServiceCode());
        if (this.track1.hasServiceCode() && this.track2.hasServiceCode() && !this.track1.getServiceCode().equals(this.track2.getServiceCode())) {
            throw new IllegalStateException("Inconsistent service between track 1 and track 2");
        }
        BankCard cardInfo = new BankCard(pan, expirationDate, name, serviceCode);
        return cardInfo;
    }

    @Override
    public String toString() {
        ServiceCode serviceCode;
        PrimaryAccountNumber pan;
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        if (this.track1.hasRawTrackData()) {
            buffer.append("Track 1: ");
            buffer.append(this.track1.getRawTrackData()).append(NEWLINE);
            if (this.track1.hasPrimaryAccountNumber()) {
                pan = this.track1.getPrimaryAccountNumber();
                buffer.append("  Primary Account Number: ");
                buffer.append(pan).append(NEWLINE);
                buffer.append("    MII: ");
                buffer.append((Object)pan.getMajorIndustryIdentifier()).append(NEWLINE);
                buffer.append("    IIN: ");
                buffer.append(pan.getIssuerIdentificationNumber()).append(NEWLINE);
                buffer.append("    Card Brand: ");
                buffer.append((Object)pan.getCardBrand()).append(NEWLINE);
            } else {
                buffer.append("  No Primary Account Number").append(NEWLINE);
            }
            if (this.track1.hasExpirationDate()) {
                buffer.append("  Expiration Date: ");
                buffer.append(formatter.format((TemporalAccessor)this.track2.getExpirationDate().getExpirationDate())).append(NEWLINE);
            } else {
                buffer.append("  No Expiration Date").append(NEWLINE);
            }
            if (this.track1.hasName()) {
                buffer.append("  Name: ");
                buffer.append(this.track1.getName()).append(NEWLINE);
            } else {
                buffer.append("  No Name").append(NEWLINE);
            }
            if (this.track1.hasServiceCode()) {
                serviceCode = this.track1.getServiceCode();
                buffer.append("  Service Code: ");
                buffer.append(NEWLINE);
                buffer.append("    ");
                buffer.append(serviceCode.getServiceCode1()).append(NEWLINE);
                buffer.append("    ");
                buffer.append(serviceCode.getServiceCode2()).append(NEWLINE);
                buffer.append("    ");
                buffer.append(serviceCode.getServiceCode3()).append(NEWLINE);
            } else {
                buffer.append("  No Service Code");
            }
            if (this.track1.hasDiscretionaryData()) {
                buffer.append("  Discretionary Data: ");
                buffer.append(this.track1.getDiscretionaryData()).append(NEWLINE);
            } else {
                buffer.append("  No Discretionary Data");
            }
        } else {
            buffer.append("No Track 1 Data").append(NEWLINE);
        }
        if (this.track2.hasRawTrackData()) {
            buffer.append("Track 2: ");
            buffer.append(this.track2.getRawTrackData()).append(NEWLINE);
            if (this.track2.hasPrimaryAccountNumber()) {
                pan = this.track2.getPrimaryAccountNumber();
                buffer.append("  Primary Account Number: ");
                buffer.append(pan).append(NEWLINE);
                buffer.append("    MII: ");
                buffer.append((Object)pan.getMajorIndustryIdentifier()).append(NEWLINE);
                buffer.append("    IIN: ");
                buffer.append(pan.getIssuerIdentificationNumber()).append(NEWLINE);
                buffer.append("    Card Brand: ");
                buffer.append((Object)pan.getCardBrand()).append(NEWLINE);
            } else {
                buffer.append("  No Primary Account Number").append(NEWLINE);
            }
            if (this.track2.hasExpirationDate()) {
                buffer.append("  Expiration Date: ");
                buffer.append(formatter.format((TemporalAccessor)this.track2.getExpirationDate().getExpirationDate())).append(NEWLINE);
            } else {
                buffer.append("  No Expiration Date").append(NEWLINE);
            }
            if (this.track2.hasServiceCode()) {
                serviceCode = this.track2.getServiceCode();
                buffer.append("  Service Code: ");
                buffer.append(NEWLINE);
                buffer.append("    ");
                buffer.append(serviceCode.getServiceCode1()).append(NEWLINE);
                buffer.append("    ");
                buffer.append(serviceCode.getServiceCode2()).append(NEWLINE);
                buffer.append("    ");
                buffer.append(serviceCode.getServiceCode3()).append(NEWLINE);
            } else {
                buffer.append("  No Service Code");
            }
            if (this.track2.hasDiscretionaryData()) {
                buffer.append("  Discretionary Data: ");
                buffer.append(this.track2.getDiscretionaryData()).append(NEWLINE);
            } else {
                buffer.append("  No Discretionary Data");
            }
        } else {
            buffer.append("No Track 2 Data").append(NEWLINE);
        }
        if (this.track3.hasRawTrackData()) {
            buffer.append("Track 3: ");
            buffer.append(this.track3.getRawTrackData()).append(NEWLINE);
            if (this.track3.hasDiscretionaryData()) {
                buffer.append("  Discretionary Data: ");
                buffer.append(this.track3.getDiscretionaryData()).append(NEWLINE);
            } else {
                buffer.append("  No Discretionary Data");
            }
        } else {
            buffer.append("No Track 3 Data").append(NEWLINE);
        }
        return buffer.toString();
    }
}

