/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import java.util.regex.Pattern;

public enum CardBrand {
    unknown(Pattern.compile("^unknown$")),
    Visa(Pattern.compile("^4[0-9]{6,}$")),
    MasterCard(Pattern.compile("^5[1-5][0-9]{5,}$")),
    AmericanExpress(Pattern.compile("^3[47][0-9]{5,}$")),
    DinersClub(Pattern.compile("^3(?:0[0-5]|[68][0-9])[0-9]{4,}$")),
    Discover(Pattern.compile("^6(?:011|5[0-9]{2})[0-9]{3,}$")),
    JCB(Pattern.compile("^(?:2131|1800|35[0-9]{3})[0-9]{3,}$"));

    private final Pattern pattern;

    public static CardBrand from(String accountNumber) {
        if (accountNumber == null) {
            return unknown;
        }
        for (CardBrand cardBrand : CardBrand.values()) {
            if (!cardBrand.pattern.matcher(accountNumber).matches()) continue;
            return cardBrand;
        }
        return unknown;
    }

    private CardBrand(Pattern pattern) {
        this.pattern = pattern;
    }
}

