/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import org.apache.commons.lang3.StringUtils;
import org.threeten.bp.YearMonth;
import org.threeten.bp.format.DateTimeFormatter;
import us.fatehi.magnetictrack.BaseTrackData;

public class ExpirationDate
extends BaseTrackData {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)"yyMM");
    private static final long serialVersionUID = 422773685360335298L;
    private final YearMonth expirationDate;

    public ExpirationDate() {
        this(null);
    }

    public ExpirationDate(String rawExpirationDate) {
        super(rawExpirationDate);
        YearMonth expirationDate;
        String expirationDateString = non_digit.matcher(StringUtils.trimToEmpty((String)rawExpirationDate)).replaceAll("");
        try {
            expirationDate = YearMonth.parse((CharSequence)expirationDateString, (DateTimeFormatter)formatter);
        }
        catch (Exception e) {
            expirationDate = null;
        }
        this.expirationDate = expirationDate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpirationDate)) {
            return false;
        }
        ExpirationDate other = (ExpirationDate)obj;
        return !(this.expirationDate == null ? other.expirationDate != null : !this.expirationDate.equals((Object)other.expirationDate));
    }

    @Override
    public boolean exceedsMaximumLength() {
        return StringUtils.trimToEmpty((String)this.getRawTrackData()).length() > 4;
    }

    public YearMonth getExpirationDate() {
        return this.expirationDate;
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
        return result;
    }

    @Override
    public String toString() {
        if (this.hasExpirationDate()) {
            return this.expirationDate.toString();
        }
        return super.toString();
    }
}

