/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

public enum MajorIndustryIdentifier {
    unknown(-1, "unknown"),
    mii_0(0, "ISO/TC 68 and other future industry assignments"),
    mii_1(1, "Airlines"),
    mii_2(2, "Airlines and other future industry assignments"),
    mii_3(3, "Travel and entertainment and banking/financial"),
    mii_4(4, "Banking and financial"),
    mii_5(5, "Banking and financial"),
    mii_6(6, "Merchandising and banking/financial"),
    mii_7(7, "Petroleum and other future industry assignments"),
    mii_8(8, "Healthcare, telecommunications and other future industry assignments"),
    mii_9(9, "National assignment");

    private final int value;
    private final String description;

    public static MajorIndustryIdentifier from(String accountNumber) {
        if (accountNumber != null && !accountNumber.isEmpty()) {
            int value = Character.digit(accountNumber.charAt(0), 10);
            for (MajorIndustryIdentifier mii : MajorIndustryIdentifier.values()) {
                if (mii.getValue() != value) continue;
                return mii;
            }
        }
        return unknown;
    }

    private MajorIndustryIdentifier(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%d - %s", this.value, this.description);
    }
}

